/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.circuits;

import com.softsynth.jsyn.BusReader;
import com.softsynth.jsyn.DelayUnit;
import com.softsynth.jsyn.Filter_1o1p;
import com.softsynth.jsyn.MultiplyAddUnit;
import com.softsynth.jsyn.SynthBusInput;
import com.softsynth.jsyn.SynthCircuit;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthInput;

public class Reverb1
extends SynthCircuit {
    static final int NUM_ELEMENTS = 6;
    Reverb1Element[] delays = new Reverb1Element[6];
    MultiplyAddUnit myMixer;
    BusReader busIn;
    double[] times = new double[]{0.05, 0.056, 0.061, 0.068, 0.072, 0.078};
    public SynthBusInput busInput;
    public SynthInput dryGain;

    public Reverb1() throws SynthException {
        this.busIn = new BusReader();
        this.add(this.busIn);
        this.myMixer = new MultiplyAddUnit();
        this.add(this.myMixer);
        for (int i = 0; i < this.delays.length; ++i) {
            Reverb1Element reverb1Element;
            this.delays[i] = reverb1Element = new Reverb1Element(this.times[i]);
            this.add(reverb1Element);
            this.busIn.output.connect(reverb1Element.input);
            reverb1Element.amplitude.set(0.15);
            if (i <= 0) continue;
            this.delays[i - 1].output.connect(this.delays[i].mix);
        }
        this.busIn.output.connect(this.myMixer.inputA);
        this.delays[5].output.connect(this.myMixer.inputC);
        this.busInput = this.busIn.busInput;
        this.addPort(this.busInput);
        this.dryGain = this.myMixer.inputB;
        this.addPort(this.dryGain, "dryGain");
        this.output = this.myMixer.output;
        this.addPort(this.output);
        this.dryGain.set(0.7);
        this.compile();
    }

    class Reverb1Element
    extends SynthCircuit {
        DelayUnit myDelay;
        Filter_1o1p myFilter;
        MultiplyAddUnit myFeedback;
        MultiplyAddUnit myMixer;
        SynthInput input;
        SynthInput mix;
        SynthInput amplitude;
        SynthInput feedback;

        public Reverb1Element(double d) throws SynthException {
            this.myDelay = new DelayUnit(d);
            this.add(this.myDelay);
            this.myFilter = new Filter_1o1p();
            this.add(this.myFilter);
            this.myFeedback = new MultiplyAddUnit();
            this.add(this.myFeedback);
            this.myMixer = new MultiplyAddUnit();
            this.add(this.myMixer);
            this.myDelay.output.connect(this.myMixer.inputA);
            this.myDelay.output.connect(this.myFilter.input);
            this.myFilter.output.connect(this.myFeedback.inputA);
            this.myFeedback.output.connect(this.myDelay.input);
            this.feedback = this.myFeedback.inputB;
            this.addPort(this.feedback, "Feedback");
            this.input = this.myFeedback.inputC;
            this.addPort(this.input, "Input");
            this.amplitude = this.myMixer.inputB;
            this.addPort(this.amplitude, "Amplitude");
            this.mix = this.myMixer.inputC;
            this.addPort(this.mix, "Mix");
            this.output = this.myMixer.output;
            this.addPort(this.output);
            this.feedback.set(-0.9);
        }
    }
}

