/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.circuits;

import com.softsynth.jsyn.BusReader;
import com.softsynth.jsyn.BusWriter;
import com.softsynth.jsyn.Filter_1o1z;
import com.softsynth.jsyn.MultiplyAddUnit;
import com.softsynth.jsyn.SampleReader_16F1;
import com.softsynth.jsyn.SampleWriter_16F1;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthCircuit;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthInput;
import com.softsynth.jsyn.SynthOutput;
import com.softsynth.jsyn.SynthSample;

public class MultiTapDelay
extends SynthCircuit {
    SynthSample delayLine;
    SampleReader_16F1[] unitReaders;
    BusWriter[] busWriters;
    BusReader busReader;
    SampleWriter_16F1 unitWriter;
    Filter_1o1z averager;
    MultiplyAddUnit feedbackMixer;
    int numSamples;
    int numTaps;
    public SynthInput input;
    public SynthInput feedback;
    public SynthOutput output;

    double findLargestDouble(double[] dArray) {
        double d = dArray[0];
        for (int i = 1; i < dArray.length; ++i) {
            if (!(d < dArray[i])) continue;
            d = dArray[i];
        }
        return d;
    }

    public MultiTapDelay(double[] dArray, double[] dArray2) throws SynthException {
        this.numTaps = dArray.length;
        double d = this.findLargestDouble(dArray) + 0.01;
        this.numSamples = (int)(d * Synth.getFrameRate());
        this.delayLine = new SynthSample(this.numSamples);
        this.unitWriter = new SampleWriter_16F1();
        this.add(this.unitWriter);
        this.feedbackMixer = new MultiplyAddUnit();
        this.add(this.feedbackMixer);
        this.busReader = new BusReader();
        this.add(this.busReader);
        this.averager = new Filter_1o1z();
        this.add(this.averager);
        this.unitReaders = new SampleReader_16F1[this.numTaps];
        this.busWriters = new BusWriter[this.numTaps];
        for (int i = 0; i < dArray.length; ++i) {
            this.unitReaders[i] = new SampleReader_16F1();
            this.add(this.unitReaders[i]);
            this.busWriters[i] = new BusWriter();
            this.add(this.busWriters[i]);
            this.unitReaders[i].output.connect(this.busWriters[i].input);
            this.unitReaders[i].amplitude.set(dArray2[i]);
            this.busWriters[i].busOutput.connect(this.busReader.busInput);
            int n = (int)(dArray[i] * Synth.getFrameRate());
            this.unitReaders[i].samplePort.queue(this.delayLine, this.numSamples - n, n);
            this.unitReaders[i].samplePort.queueLoop(this.delayLine, 0, this.numSamples);
        }
        this.unitWriter.samplePort.queueLoop(this.delayLine, 0, this.numSamples);
        this.busReader.output.connect(this.averager.input);
        this.averager.output.connect(this.feedbackMixer.inputA);
        this.feedbackMixer.output.connect(this.unitWriter.input);
        this.input = this.feedbackMixer.inputC;
        this.addPort(this.input, "input");
        this.feedback = this.feedbackMixer.inputB;
        this.addPort(this.feedback, "feedback");
        this.output = this.busReader.output;
        this.addPort(this.output);
    }
}

