/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.circuits;

import com.softsynth.jsyn.EnvelopePlayer;
import com.softsynth.jsyn.MultiplyAddUnit;
import com.softsynth.jsyn.MultiplyUnit;
import com.softsynth.jsyn.SineOscillator;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthContext;
import com.softsynth.jsyn.SynthEnvelope;
import com.softsynth.jsyn.SynthEnvelopeQueue;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthInput;
import com.softsynth.jsyn.SynthNote;
import com.softsynth.jsyn.SynthOutput;

public class FMOperator
extends SynthNote {
    SineOscillator osc;
    MultiplyUnit freqScalar;
    MultiplyAddUnit freqMixer;
    MultiplyAddUnit ampMixer;
    EnvelopePlayer envPlayer;
    public SynthInput scale;
    public SynthInput depth;
    public SynthInput index;
    public SynthInput input;
    public SynthOutput actualFrequency;
    public SynthEnvelopeQueue envelopePort;
    public SynthEnvelope envelope;

    public FMOperator() {
        this(Synth.getSharedContext());
    }

    public FMOperator(SynthContext synthContext) {
        this.makeCircuit(synthContext);
        this.addAllPorts();
    }

    public void makeCircuit(SynthContext synthContext) {
        this.osc = new SineOscillator(synthContext);
        this.add(this.osc);
        this.freqMixer = new MultiplyAddUnit(synthContext);
        this.add(this.freqMixer);
        this.ampMixer = new MultiplyAddUnit(synthContext);
        this.add(this.ampMixer);
        this.freqScalar = new MultiplyUnit(synthContext);
        this.add(this.freqScalar);
        this.envPlayer = new EnvelopePlayer(synthContext);
        this.add(this.envPlayer);
        this.osc.output.connect(this.envPlayer.amplitude);
        this.freqScalar.output.connect(this.freqMixer.inputC);
        this.freqScalar.output.connect(this.ampMixer.inputA);
        this.freqMixer.output.connect(this.osc.frequency);
        this.ampMixer.output.connect(this.osc.amplitude);
        this.frequency = this.freqScalar.inputA;
        this.scale = this.freqScalar.inputB;
        this.input = this.freqMixer.inputA;
        this.depth = this.freqMixer.inputB;
        this.actualFrequency = this.freqMixer.output;
        this.amplitude = this.ampMixer.inputC;
        this.index = this.ampMixer.inputB;
        this.output = this.envPlayer.output;
        this.envelopePort = this.envPlayer.envelopePort;
        this.input.set(0.0);
        this.index.setup(0.0, 0.0, 30.0);
        this.scale.setup(0.001, 1.0, 8000.0);
        this.amplitude.setup(0.0, 1.0, 1.0);
        this.frequency.setup(0.0, 300.0, 8000.0);
        this.depth.setup(0.001, 1.0, 1000.0);
    }

    public void setEnvelope(SynthEnvelope synthEnvelope) {
        this.envelope = synthEnvelope;
    }

    public void addAllPorts() {
        this.addPort(this.frequency, "frequency");
        this.addPort(this.amplitude, "amplitude");
        this.addPort(this.output);
        this.addPort(this.scale, "scale");
        this.addPort(this.input, "input");
        this.addPort(this.index, "index");
        this.addPort(this.depth, "depth");
        this.addPort(this.envelopePort);
    }

    public void setStage(int n, int n2) throws SynthException {
        if (n2 == 0) {
            if (this.envelope != null) {
                this.envPlayer.envelopePort.clear(n);
                this.envPlayer.envelopePort.queueOn(n, this.envelope);
            }
        } else if (n2 == 1 && this.envelope != null) {
            this.envPlayer.envelopePort.queueOff(n, this.envelope);
        }
    }
}

