/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.bridge;

import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.bridge.ThingTracker;
import java.util.logging.Logger;

public class ThingTable {
    private static final int MAX_THINGS = 4096;
    public static final int INVALID_TOKEN = 0;
    private ThingTracker[] things;
    private byte[] reuseCounts;
    private int thingsAllocated;
    private static int s_nextId;
    private int id;
    private static Logger s_logger;

    public ThingTable() {
        s_logger.fine("allocate table sized 4096");
        this.things = new ThingTracker[4096];
        this.reuseCounts = new byte[4096];
        this.id = s_nextId;
        s_logger.fine("create thing table with id = " + this.id);
        s_nextId = s_nextId + 1 & 0x7F;
    }

    public synchronized void clear() {
        for (int i = 0; i < this.things.length; ++i) {
            this.things[i] = null;
        }
        this.thingsAllocated = 0;
    }

    public synchronized int addThing(Object object) {
        int n = 0;
        for (int i = 1; i < this.things.length; ++i) {
            if (this.things[i] != null) continue;
            this.reuseCounts[i] = (byte)(this.reuseCounts[i] + 1 & 0x7F);
            if (this.reuseCounts[i] == 0) {
                this.reuseCounts[i] = 1;
            }
            this.things[i] = new ThingTracker();
            this.things[i].setThing(object);
            ++this.thingsAllocated;
            n = this.indexToToken(i);
            break;
        }
        s_logger.fine(String.format("addThing returned %x\n", n));
        if (n == 0) {
            throw new SynthException(-88, "Could not allocate a slot in token table.");
        }
        return n;
    }

    private int indexToToken(int n) {
        return (this.id << 24) + (this.reuseCounts[n] << 16) + (n & 0xFFFF);
    }

    private int tokenToIndex(int n) {
        return n & 0xFFFF;
    }

    private int tokenToReuseCount(int n) {
        return n >> 16 & 0xFF;
    }

    private int tokenToId(int n) {
        return n >> 24 & 0xFF;
    }

    public synchronized void freeToken(int n) {
        s_logger.fine(String.format("free %x\n", n));
        int n2 = this.tokenToIndex(n);
        this.validateToken(n, n2);
        this.things[n2] = null;
        --this.thingsAllocated;
    }

    public synchronized Object tokenToThing(int n) {
        s_logger.finer(String.format("lookup %x\n", n));
        int n2 = this.tokenToIndex(n);
        this.validateToken(n, n2);
        ThingTracker thingTracker = this.things[n2];
        if (thingTracker == null) {
            throw new SynthException(-98, n);
        }
        return thingTracker.getThing();
    }

    private void validateToken(int n, int n2) {
        int n3 = this.tokenToReuseCount(n);
        int n4 = this.tokenToId(n);
        if (n3 != this.reuseCounts[n2]) {
            throw new SynthException(-98, n);
        }
        s_logger.finest("thing tokenId = " + n4 + ",  table id = " + this.id);
        if (n4 != this.id) {
            throw new SynthException(-98, "Token from wrong context = " + Integer.toHexString(n), n4, this.id);
        }
    }

    public int size() {
        return this.thingsAllocated;
    }

    static {
        s_logger = Logger.getLogger(ThingTable.class.getName());
    }
}

