/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.bridge;

import com.jsyn.engine.SynthesisEngine;
import com.jsyn.ports.UnitInputPort;
import com.jsyn.ports.UnitOutputPort;
import com.jsyn.unitgen.UnitGenerator;

public class PitchDetector
extends UnitGenerator {
    public UnitInputPort input;
    public UnitOutputPort periodPort;
    public UnitOutputPort confidencePort;
    private double sampleRate;
    private double period;
    private double confidence;
    private double score;
    private double newPeriod;
    private double maxPeriod;
    private double minPeriod;
    private int countdown;
    private double previousLevel;
    private double previousSlope;
    private double previousMinimum;
    private double previousMaximum;
    private double hysteresisLevel;
    private HysteresisState hysteresisState;
    private int numFeatures;
    private int featureIndex;
    private short index;
    private static final int MAX_FEATURES_CONSIDER = 40;
    private static final int MINIMUM_FREQUENCY = 20;
    private static final int MAXIMUM_FREQUENCY = 2400;
    private static final int NUM_FEATURES = 256;
    private static final int NUM_FEATURE_MASK = 255;
    private FeatureRecord[] features = new FeatureRecord[256];

    public PitchDetector() {
        this.input = new UnitInputPort("Input");
        this.addPort(this.input);
        this.periodPort = new UnitOutputPort("Period");
        this.addPort(this.periodPort);
        this.confidencePort = new UnitOutputPort("Confidence");
        this.addPort(this.confidencePort);
        this.features = new FeatureRecord[256];
        for (int i = 0; i < 256; ++i) {
            this.features[i] = new FeatureRecord();
        }
        this.hysteresisLevel = 0.01;
        this.newPeriod = this.period = 100.0;
    }

    public void setSynthesisEngine(SynthesisEngine synthesisEngine) {
        super.setSynthesisEngine(synthesisEngine);
        this.sampleRate = synthesisEngine.getFrameRate();
        this.maxPeriod = this.sampleRate / 20.0;
        this.minPeriod = this.sampleRate / 2400.0;
    }

    public void generate(int n, int n2) {
        double[] dArray = this.input.getValues();
        double[] dArray2 = this.periodPort.getValues();
        double[] dArray3 = this.confidencePort.getValues();
        for (int i = n; i < n2; ++i) {
            this.analyze(dArray[i]);
            dArray2[i] = this.period;
            dArray3[i] = this.confidence;
        }
    }

    private FeatureRecord GetNextFeatureRecord() {
        FeatureRecord featureRecord = this.features[this.featureIndex++];
        this.featureIndex &= 0xFF;
        ++this.numFeatures;
        if (this.numFeatures >= 255) {
            this.numFeatures = 255;
        }
        return featureRecord;
    }

    private double CalculateSimilarity(double d, double d2) {
        double d3 = d - d2;
        double d4 = d3 * d3;
        double d5 = d + d2;
        double d6 = d5 * d5;
        if (d5 < 1.0) {
            d5 = 1.0;
        }
        double d7 = 1.0 - d4 / d6;
        return d7;
    }

    private void MatchFeatures() {
        int n;
        FeatureRecord featureRecord;
        double d;
        double d2 = this.maxPeriod;
        double d3 = 0.0;
        if (this.numFeatures < 4) {
            return;
        }
        int n2 = this.featureIndex - 1 & 0xFF;
        FeatureRecord featureRecord2 = this.features[n2];
        int n3 = this.numFeatures / 2 < 40 ? this.numFeatures / 2 : 40;
        for (int i = 1; i < n3 && !((d = this.CalculatePeriod(featureRecord2, featureRecord = this.features[n = n2 - i & 0xFF])) > this.maxPeriod); ++i) {
            double d4 = 0.0;
            if (featureRecord.type != featureRecord2.type || !(d > this.minPeriod)) continue;
            int n4 = n;
            FeatureRecord featureRecord3 = null;
            FeatureRecord featureRecord4 = null;
            double d5 = 0.0;
            int n5 = 0;
            int n6 = 0;
            int n7 = n2;
            while (n7 != n && n5 < 40) {
                double d6 = 0.0;
                featureRecord3 = this.features[n7];
                while (n4 != n2 && (d6 = this.CalculatePeriod(featureRecord3, featureRecord4 = this.features[n4])) < 0.95 * d) {
                    n4 = n4 - 1 & 0xFF;
                }
                if (n4 == n2) break;
                int n8 = n4;
                ++n6;
                while (d6 < 1.05 * d && n5 < 40) {
                    if (featureRecord3.type == featureRecord4.type) {
                        double d7 = featureRecord3.value * featureRecord4.value;
                        d5 += d7;
                        d4 += d6 * d7;
                        ++n5;
                    }
                    if ((n8 = n8 - 1 & 0xFF) == n2) break;
                    featureRecord4 = this.features[n8];
                    d6 = this.CalculatePeriod(featureRecord3, featureRecord4);
                }
                n7 = n7 - 1 & 0xFF;
            }
            if (n5 <= 0) continue;
            double d8 = d4 / d5;
            double d9 = d5 / ((double)n6 * d8);
            double d10 = this.CalculateSimilarity(d8, this.period);
            double d11 = 0.4 * this.score * d10;
            if (!((d9 += d11) > d3)) continue;
            d3 = d9;
            d2 = d8;
        }
        if (d3 > 0.0) {
            if ((d2 > 0.9 * this.period && d2 < 1.1 * this.period || d2 > 0.9 * this.newPeriod && d2 < 1.1 * this.newPeriod) && d3 > 0.2 * this.score) {
                this.countdown = (int)d2;
                this.period = d2;
                this.score = d3;
                this.confidence = d3 * d2;
            }
            this.newPeriod = d2;
        }
    }

    private double CalculatePeriod(FeatureRecord featureRecord, FeatureRecord featureRecord2) {
        return (double)(featureRecord.index - featureRecord2.index) + (featureRecord.fraction - featureRecord2.fraction);
    }

    private void analyze(double d) {
        Object object;
        double d2;
        int n = 0;
        boolean bl = false;
        double d3 = d - this.previousLevel;
        if (this.hysteresisState == HysteresisState.GoingUp) {
            d2 = d - this.hysteresisLevel;
            if (d2 > 0.0) {
                this.hysteresisState = HysteresisState.GoingDown;
                bl = true;
            }
        } else {
            d2 = d - -this.hysteresisLevel;
            if (d2 < 0.0) {
                this.hysteresisState = HysteresisState.GoingUp;
                bl = true;
            }
        }
        if (bl) {
            object = this.GetNextFeatureRecord();
            object.value = 10.0 * d3;
            object.index = (short)(this.index - 1);
            object.fraction = 1.0 - d2 / d3;
            object.type = this.hysteresisState == HysteresisState.GoingDown ? FeatureType.RisingZeroCrossing : FeatureType.FallingZeroCrossing;
            this.MatchFeatures();
            ++n;
        }
        if (d3 < 0.0 ^ this.previousSlope < 0.0) {
            object = FeatureType.Unspecified;
            if (d3 - this.previousSlope > 0.0) {
                if (d < 0.9 * this.previousMaximum) {
                    object = FeatureType.LocalMinimum;
                    this.previousMinimum = d;
                }
            } else if (d > 0.9 * this.previousMinimum) {
                object = FeatureType.LocalMaximum;
                this.previousMaximum = d;
            }
            if (object != FeatureType.Unspecified) {
                FeatureRecord featureRecord = this.GetNextFeatureRecord();
                featureRecord.value = d;
                featureRecord.type = d3 - this.previousSlope > 0.0 ? FeatureType.LocalMinimum : FeatureType.LocalMaximum;
                featureRecord.index = (short)(this.index - 1);
                featureRecord.fraction = 1.0 - d3 / featureRecord.value;
                ++n;
            }
        }
        this.previousLevel = d;
        this.previousSlope = d3;
        this.index = (short)(this.index + 1);
        if (this.countdown <= 0) {
            this.score *= (double)0.999f;
            if (this.score < 1.0E-20) {
                this.score = 0.0;
            }
            this.confidence = this.score * this.period;
        } else {
            --this.countdown;
        }
    }

    private Object CalculatePosition(FeatureRecord featureRecord) {
        return (double)featureRecord.index + featureRecord.fraction;
    }

    static class ExtraParameter {
        double value;

        ExtraParameter() {
        }
    }

    static class FeatureRecord {
        FeatureType type = FeatureType.Unspecified;
        short index;
        double fraction;
        double value;

        FeatureRecord() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum HysteresisState {
        GoingUp,
        GoingDown;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum FeatureType {
        Unspecified,
        RisingZeroCrossing,
        LocalMaximum,
        FallingZeroCrossing,
        LocalMinimum;

    }
}

