/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.bridge;

import com.jsyn.data.DoubleTable;
import com.jsyn.data.SegmentedEnvelope;
import com.jsyn.data.SequentialData;
import com.jsyn.data.ShortSample;
import com.jsyn.devices.AudioDeviceFactory;
import com.jsyn.devices.AudioDeviceManager;
import com.jsyn.engine.SynthesisEngine;
import com.jsyn.exceptions.ChannelMismatchException;
import com.jsyn.ports.GettablePort;
import com.jsyn.ports.QueueDataCommand;
import com.jsyn.ports.SettablePort;
import com.jsyn.ports.UnitBlockPort;
import com.jsyn.ports.UnitDataQueuePort;
import com.jsyn.ports.UnitFunctionPort;
import com.jsyn.ports.UnitInputPort;
import com.jsyn.ports.UnitOutputPort;
import com.jsyn.ports.UnitPort;
import com.jsyn.unitgen.Circuit;
import com.jsyn.unitgen.UnitGenerator;
import com.softsynth.jsyn.CSynAudioInterface;
import com.softsynth.jsyn.CSynInterface;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.bridge.CSynErrors;
import com.softsynth.jsyn.bridge.PortsByNameHash;
import com.softsynth.jsyn.bridge.SignalTypeLookup;
import com.softsynth.jsyn.bridge.ThingTable;
import com.softsynth.jsyn.bridge.UnitBusInputPort;
import com.softsynth.jsyn.bridge.UnitInfo;
import com.softsynth.jsyn.bridge.UnitsByNameHash;
import com.softsynth.shared.time.ScheduledCommand;
import com.softsynth.shared.time.TimeStamp;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CSynJavaImplementation
implements CSynInterface,
CSynAudioInterface {
    private SynthesisEngine synthesisEngine;
    private ThingTable things;
    private double tickPeriod;
    private boolean useRealTime;
    private int openCount;
    private int startCount;
    private AudioDeviceManager audioDevice;
    private Level logLevel = Level.FINE;
    private static Logger logger = Logger.getLogger("com.softsynth.jsyn.bridge.CSynJavaImplementation");

    public CSynJavaImplementation() {
        this.audioDevice = AudioDeviceFactory.createAudioDeviceManager();
    }

    public synchronized void initialize() throws SynthException {
        logger.log(this.logLevel, "initialize: openCount = " + this.openCount);
        if (this.openCount == 0) {
            this.synthesisEngine = new SynthesisEngine();
            logger.log(this.logLevel, "initialize: synthesisEngine = " + this.synthesisEngine);
            this.synthesisEngine.setPullDataEnabled(false);
            this.things = new ThingTable();
            this.tickPeriod = 1.0 / this.getTickRate();
        }
        ++this.openCount;
    }

    public synchronized void terminate() {
        logger.log(this.logLevel, "terminate: openCount = " + this.openCount);
        if (this.openCount == 1) {
            logger.log(this.logLevel, "synthesisEngine was " + this.synthesisEngine);
            this.synthesisEngine.terminate();
            this.things.clear();
            this.things = null;
        }
        if (this.openCount > 0) {
            --this.openCount;
        }
    }

    public synchronized void delete() {
    }

    public double getUsage() {
        return this.synthesisEngine.getUsage();
    }

    public int getObjectCount() {
        return this.things.size();
    }

    public int getFrameCount() {
        return (int)this.synthesisEngine.getFrameCount();
    }

    public int getTickCount() {
        return (int)(this.synthesisEngine.getFrameCount() >> 6);
    }

    public int getFramesPerTick() {
        return 64;
    }

    public double getFrameRate() {
        return this.synthesisEngine.getFrameRate();
    }

    public double getTickRate() {
        return this.getFrameRate() / (double)this.getFramesPerTick();
    }

    public int createUnit(int n, int n2, int n3) {
        UnitInfo unitInfo = UnitsByNameHash.get(n);
        if (unitInfo == null) {
            throw new SynthException("Unimplemented unit generator.");
        }
        UnitGenerator unitGenerator = unitInfo.createUnit(this.synthesisEngine, n3);
        return this.things.addThing(unitGenerator);
    }

    public int stopUnit(int n) {
        return this.stopUnitAt(this.getTickCount(), n);
    }

    public int startUnit(int n) {
        return this.startUnitAt(this.getTickCount(), n);
    }

    public int stopUnitAt(int n, int n2) {
        UnitGenerator unitGenerator = this.tokenToUnit(n2);
        TimeStamp timeStamp = this.createTimeStamp(n);
        this.synthesisEngine.stopUnit(unitGenerator, timeStamp);
        return 0;
    }

    public int startUnitAt(int n, int n2) {
        UnitGenerator unitGenerator = this.tokenToUnit(n2);
        TimeStamp timeStamp = this.createTimeStamp(n);
        this.synthesisEngine.startUnit(unitGenerator, timeStamp);
        return 0;
    }

    public int setPort(int n, int n2, int n3, double d) {
        return this.setPortAt(this.getTickCount(), n, n2, n3, d);
    }

    private TimeStamp createTimeStamp(int n) {
        return new TimeStamp((double)n * this.tickPeriod);
    }

    public int setPortAt(int n, int n2, int n3, int n4, double d) {
        SettablePort settablePort = (SettablePort)((Object)this.lookupPort(n2, n3));
        logger.log(this.logLevel, "set port " + settablePort.getName() + " on token = " + n2 + " to " + d);
        if (n4 >= settablePort.getNumParts()) {
            return -96;
        }
        TimeStamp timeStamp = this.createTimeStamp(n);
        settablePort.set(n4, d, timeStamp);
        return 0;
    }

    public double getPort(int n, int n2, int n3) {
        GettablePort gettablePort = (GettablePort)((Object)this.lookupPort(n, n2));
        if (n3 >= gettablePort.getNumParts()) {
            return -96.0;
        }
        return gettablePort.getValue(n3);
    }

    public int setPortSignalType(int n, int n2, int n3, int n4) {
        return 0;
    }

    public int getPortSignalType(int n, int n2, int n3) {
        SettablePort settablePort = (SettablePort)((Object)this.lookupPort(n, n2));
        int n4 = SignalTypeLookup.getSignalType(settablePort.getUnitGenerator().getClass(), settablePort.getName());
        return n4;
    }

    public int getNumParts(int n, int n2) {
        UnitPort unitPort = this.lookupPort(n, n2);
        return unitPort.getNumParts();
    }

    public int connectUnits(int n, int n2, int n3, int n4, int n5, int n6) {
        UnitOutputPort unitOutputPort = (UnitOutputPort)this.lookupPort(n, n2);
        UnitInputPort unitInputPort = (UnitInputPort)this.lookupPort(n4, n5);
        if (n3 >= unitOutputPort.getNumParts()) {
            return -96;
        }
        if (n6 >= unitInputPort.getNumParts()) {
            return -96;
        }
        if (!(unitInputPort instanceof UnitBusInputPort)) {
            unitInputPort.disconnectAll(n6);
        }
        unitInputPort.connect(n6, unitOutputPort, n3);
        return 0;
    }

    public int disconnectUnits(int n, int n2, int n3) {
        UnitBlockPort unitBlockPort = (UnitBlockPort)this.lookupPort(n, n2);
        unitBlockPort.disconnectAll(n3);
        return 0;
    }

    private UnitPort lookupPort(int n, int n2) {
        String string;
        UnitGenerator unitGenerator = this.tokenToUnit(n);
        UnitPort unitPort = unitGenerator.getPortByName(string = PortsByNameHash.get(n2));
        if (unitPort == null) {
            throw new SynthException("Port " + string + " not found on unit " + unitGenerator);
        }
        return unitPort;
    }

    private UnitGenerator tokenToUnit(int n) {
        if (this.things == null) {
            throw new SynthException(-83, "Engine not initialized.");
        }
        return (UnitGenerator)this.things.tokenToThing(n);
    }

    public int setPriority(int n, int n2) {
        return 0;
    }

    public int getPriority(int n) {
        return 0;
    }

    public int createTable(int n) {
        DoubleTable doubleTable = new DoubleTable(n);
        return this.things.addThing(doubleTable);
    }

    public int writeTable(int n, int n2, int n3, short[] sArray, int n4, int n5) {
        DoubleTable doubleTable = (DoubleTable)this.things.tokenToThing(n);
        doubleTable.write(n2, sArray, n4, n3);
        return 0;
    }

    public int writeTableDoubles(int n, int n2, int n3, double[] dArray, int n4, int n5) {
        DoubleTable doubleTable = (DoubleTable)this.things.tokenToThing(n);
        doubleTable.write(n2, dArray, n4, n3);
        return 0;
    }

    public int useTable(int n, int n2, int n3, int n4) {
        UnitFunctionPort unitFunctionPort = (UnitFunctionPort)this.lookupPort(n, n2);
        DoubleTable doubleTable = (DoubleTable)this.things.tokenToThing(n4);
        if (doubleTable == null) {
            throw new SynthException("SynthTable not found.");
        }
        if (n3 > 0) {
            throw new SynthException("Multiple parts not supported in SynthTablePort.");
        }
        unitFunctionPort.set(doubleTable);
        return 0;
    }

    public int createEnvelope(int n) {
        SegmentedEnvelope segmentedEnvelope = new SegmentedEnvelope(n);
        return this.things.addThing(segmentedEnvelope);
    }

    public int writeEnvelope(int n, int n2, int n3, double[] dArray, int n4, int n5) {
        SegmentedEnvelope segmentedEnvelope = (SegmentedEnvelope)this.things.tokenToThing(n);
        segmentedEnvelope.write(n2, dArray, n4, n3);
        return 0;
    }

    public int readEnvelope(int n, int n2, int n3, double[] dArray, int n4, int n5) {
        SegmentedEnvelope segmentedEnvelope = (SegmentedEnvelope)this.things.tokenToThing(n);
        segmentedEnvelope.read(n2, dArray, n4, n3);
        return 0;
    }

    public int createSample(int n, int n2) {
        ShortSample shortSample = new ShortSample(n, n2);
        return this.things.addThing(shortSample);
    }

    public int writeSample(int n, int n2, int n3, short[] sArray, int n4, int n5) {
        ShortSample shortSample = (ShortSample)this.things.tokenToThing(n);
        shortSample.write(n2, sArray, n4, n3);
        return 0;
    }

    public int readSample(int n, int n2, int n3, short[] sArray, int n4, int n5) {
        ShortSample shortSample = (ShortSample)this.things.tokenToThing(n);
        shortSample.read(n2, sArray, n4, n3);
        return 0;
    }

    public int clearDataQueue(int n, int n2) {
        UnitDataQueuePort unitDataQueuePort = (UnitDataQueuePort)this.lookupPort(n, n2);
        unitDataQueuePort.clear();
        return 0;
    }

    public int clearDataQueueAt(int n, int n2, int n3) {
        UnitDataQueuePort unitDataQueuePort = (UnitDataQueuePort)this.lookupPort(n2, n3);
        TimeStamp timeStamp = this.createTimeStamp(n);
        unitDataQueuePort.clear(timeStamp);
        return 0;
    }

    public int queueData(int n, int n2, int n3, int n4, int n5, int n6) {
        return this.queueDataAt(this.getTickCount(), n, n2, n3, n4, n5, n6);
    }

    public int queueDataAt(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        logger.log(this.logLevel, "queue dataToken = " + n4 + ", startFrame = " + n5 + ", numFrames = " + n6 + ", flags = " + n7);
        UnitDataQueuePort unitDataQueuePort = (UnitDataQueuePort)this.lookupPort(n2, n3);
        SequentialData sequentialData = (SequentialData)this.things.tokenToThing(n4);
        if (sequentialData == null) {
            throw new SynthException("SynthSample not found.");
        }
        TimeStamp timeStamp = this.createTimeStamp(n);
        try {
            QueueDataCommand queueDataCommand = unitDataQueuePort.createQueueDataCommand(sequentialData, n5, n6);
            if ((n7 & 0x10) != 0) {
                queueDataCommand.setAutoStop(true);
            }
            if ((n7 & 8) != 0) {
                queueDataCommand.setNumLoops(-1);
            }
            if ((n7 & 0x80) != 0) {
                queueDataCommand.setSkipIfOthers(true);
            }
            this.synthesisEngine.scheduleCommand(timeStamp, (ScheduledCommand)queueDataCommand);
        }
        catch (ChannelMismatchException channelMismatchException) {
            return -66;
        }
        return 0;
    }

    public int getPortFrames(int n, int n2, int n3) {
        UnitDataQueuePort unitDataQueuePort = (UnitDataQueuePort)this.lookupPort(n, n2);
        int n4 = (int)unitDataQueuePort.getFrameCount();
        if (n4 == -1) {
            n4 = -2;
        }
        return n4;
    }

    public int createCircuit(int[] nArray, int n, int n2) throws SynthException {
        Circuit circuit = new Circuit();
        for (int n3 : nArray) {
            UnitGenerator unitGenerator = this.tokenToUnit(n3);
            circuit.add(unitGenerator);
        }
        return this.things.addThing(circuit);
    }

    public int delete(int n) {
        this.things.freeToken(n);
        return 0;
    }

    public void setTrace(int n) {
    }

    public int getTrace() {
        return 0;
    }

    public void checkEngineErrors() {
    }

    public int debug(int n, int n2) {
        return 0;
    }

    public int errorCodeToText(int n, byte[] byArray, int n2) {
        String string = CSynErrors.errorCodeToText(n);
        int n3 = string.length() < byArray.length ? string.length() : byArray.length;
        string.getBytes(0, n3, byArray, 0);
        return n3;
    }

    public int getVersion() {
        return 151;
    }

    public int sleepUntilTick(int n) {
        int n2 = this.getTickCount();
        while (n - n2 > 0) {
            if (this.useRealTime) {
                throw new RuntimeException("Low level sleepUntilTick called in real-time mode!");
            }
            this.synthesisEngine.generateNextBuffer();
            n2 = this.getTickCount();
        }
        return 0;
    }

    public void stop() {
        logger.log(this.logLevel, "startCount = " + this.startCount);
        if (this.startCount == 1) {
            logger.log(this.logLevel, "stopping!");
            this.synthesisEngine.stop();
        }
        if (this.startCount > 0) {
            --this.startCount;
        }
    }

    public void startDevices(int n, double d, int n2, int n3, int n4, int n5) {
        logger.log(this.logLevel, "startCount = " + this.startCount);
        if (this.startCount == 0) {
            this.synthesisEngine.setRealTime((n & 4) == 0);
            this.synthesisEngine.start((int)d, n2, n3, n4, n5);
        }
        ++this.startCount;
    }

    public int getNumDevices() {
        return this.audioDevice.getDeviceCount();
    }

    public int getDefaultInputDeviceID() {
        return this.audioDevice.getDefaultInputDeviceID();
    }

    public int getDefaultOutputDeviceID() {
        return this.audioDevice.getDefaultOutputDeviceID();
    }

    public int getMaxInputChannels(int n) {
        return this.audioDevice.getMaxInputChannels(n);
    }

    public int getMaxOutputChannels(int n) {
        return this.audioDevice.getMaxOutputChannels(n);
    }

    public int setSuggestedInputLatency(double d) {
        return this.audioDevice.setSuggestedInputLatency(d);
    }

    public int setSuggestedOutputLatency(double d) {
        return this.audioDevice.setSuggestedOutputLatency(d);
    }

    public double getOutputLatency() {
        return this.synthesisEngine.getOutputLatency();
    }

    public double getInputLatency() {
        return this.synthesisEngine.getInputLatency();
    }

    public double getDefaultHighInputLatency(int n) {
        return this.audioDevice.getDefaultHighInputLatency(n);
    }

    public double getDefaultHighOutputLatency(int n) {
        return this.audioDevice.getDefaultHighOutputLatency(n);
    }

    public double getDefaultLowInputLatency(int n) {
        return this.audioDevice.getDefaultLowInputLatency(n);
    }

    public double getDefaultLowOutputLatency(int n) {
        return this.audioDevice.getDefaultLowOutputLatency(n);
    }

    public int getDeviceName(int n, byte[] byArray, int n2) {
        String string = this.audioDevice.getDeviceName(n);
        int n3 = string.length() < byArray.length ? string.length() : byArray.length;
        string.getBytes(0, n3, byArray, 0);
        return n3;
    }
}

