/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn;

import com.softsynth.jsyn.ChunkHandler;
import com.softsynth.jsyn.CuePoint;
import com.softsynth.jsyn.ParseIFF;
import com.softsynth.jsyn.ParseRIFF;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthContext;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthSample;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class SynthSampleWAV
extends SynthSample
implements ChunkHandler {
    static final short WAVE_FORMAT_PCM = 1;
    static final int WAVE_ID = 1463899717;
    static final int FMT_ID = 1718449184;
    static final int DATA_ID = 1684108385;
    static final int CUE_ID = 1668637984;
    private int bitsPerSample;
    private int bytesPerBlock;

    public SynthSampleWAV(SynthContext synthContext, InputStream inputStream) throws SynthException, IOException {
        super(synthContext);
        this.load(inputStream);
    }

    public SynthSampleWAV(SynthContext synthContext) {
        super(synthContext);
    }

    public SynthSampleWAV(InputStream inputStream) throws SynthException, IOException {
        this.load(inputStream);
    }

    public SynthSampleWAV() {
    }

    public short[] loadShorts(InputStream inputStream, boolean bl) throws SynthException, IOException {
        short[] sArray = null;
        this.ifLoadData = bl;
        ParseRIFF parseRIFF = new ParseRIFF(inputStream);
        this.parser = parseRIFF;
        parseRIFF.parse(this);
        if (bl && this.numFrames > 0) {
            sArray = this.bitsPerSample == 8 ? this.convertUnsignedBytesToShorts() : this.convertLittleBytesToShorts();
        }
        this.byteData = null;
        this.parser = null;
        return sArray;
    }

    void setLoopPoints() {
        if (this.cuePoints != null && this.cuePoints.size() >= 2) {
            this.setSustainLoop(((CuePoint)this.cuePoints.elementAt(0)).getPosition(), ((CuePoint)this.cuePoints.elementAt(1)).getPosition());
        }
    }

    void parseCueChunk(ParseIFF parseIFF, int n) throws IOException {
        int n2 = parseIFF.readIntLittle();
        if (n - 4 != 24 * n2) {
            throw new EOFException("Cue chunk too short!");
        }
        for (int i = 0; i < n2; ++i) {
            int n3 = parseIFF.readIntLittle();
            int n4 = parseIFF.readIntLittle();
            parseIFF.skip(16L);
            this.insertSortedCue(new CuePoint(n4, n3));
        }
        this.setLoopPoints();
    }

    void parseFmtChunk(ParseIFF parseIFF, int n) throws IOException {
        short s = parseIFF.readShortLittle();
        if (s != 1) {
            throw new IOException("Only WAVE_FORMAT_PCM supported, not " + s);
        }
        this.channelsPerFrame = parseIFF.readShortLittle();
        this.setSampleRate(parseIFF.readIntLittle());
        parseIFF.readIntLittle();
        this.bytesPerBlock = parseIFF.readShortLittle();
        this.bitsPerSample = parseIFF.readShortLittle();
        if (this.bitsPerSample != 16 && this.bitsPerSample != 8) {
            throw new IOException("Only 8 or 16 bit samples supported.");
        }
        int n2 = (this.bitsPerSample + 7) / 8;
        int n3 = n2 * this.channelsPerFrame;
        if (this.bytesPerBlock != n3) {
            throw new IOException("bytesPerBlock = " + this.bytesPerBlock + ", expected " + n3);
        }
    }

    void parseDataChunk(ParseIFF parseIFF, int n) throws IOException {
        long l;
        if (Synth.verbosity > 1) {
            System.out.println("parseDataChunk()");
        }
        this.dataPosition = parseIFF.getOffset();
        if (this.ifLoadData) {
            this.byteData = new byte[n];
            l = parseIFF.read(this.byteData);
        } else {
            l = parseIFF.skip(n);
        }
        if (l != (long)n) {
            throw new EOFException("WAV data chunk too short! Read " + l + " instead of " + n);
        }
        this.numFrames = n / this.bytesPerBlock;
    }

    public void handleForm(ParseIFF parseIFF, int n, int n2, int n3) throws IOException {
        if (n == 1380533830 && n3 != 1463899717) {
            throw new IOException("Bad WAV form type = " + ParseIFF.IDToString(n3));
        }
    }

    public void handleChunk(ParseIFF parseIFF, int n, int n2) throws IOException {
        switch (n) {
            case 1718449184: {
                this.parseFmtChunk(parseIFF, n2);
                break;
            }
            case 1684108385: {
                this.parseDataChunk(parseIFF, n2);
                break;
            }
            case 1668637984: {
                this.parseCueChunk(parseIFF, n2);
                break;
            }
        }
    }
}

