/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn;

import com.softsynth.jsyn.MultiplyAddUnit;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthCircuit;
import com.softsynth.jsyn.SynthContext;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthInput;
import com.softsynth.jsyn.SynthOutput;

public class SynthMixer
extends SynthCircuit {
    int numInputs;
    int numOutputs;
    MultiplyAddUnit[][] nodes;

    public SynthMixer(int n, int n2) throws SynthException {
        this(Synth.getSharedContext(), n, n2);
    }

    public SynthMixer(SynthContext synthContext, int n, int n2) throws SynthException {
        this.numInputs = n;
        this.numOutputs = n2;
        this.nodes = new MultiplyAddUnit[n][n2];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                MultiplyAddUnit multiplyAddUnit = new MultiplyAddUnit(synthContext);
                this.nodes[j][i] = multiplyAddUnit;
                this.add(multiplyAddUnit);
                if (j <= 0) continue;
                this.nodes[j - 1][i].output.connect(this.nodes[j][i].inputC);
            }
        }
    }

    public void connectInput(int n, SynthOutput synthOutput, int n2) throws SynthException {
        for (int i = 0; i < this.numOutputs; ++i) {
            MultiplyAddUnit multiplyAddUnit = this.nodes[n][i];
            synthOutput.connect(n2, multiplyAddUnit.inputA, 0);
        }
    }

    public SynthOutput getOutput(int n) {
        return this.nodes[this.numInputs - 1][n].output;
    }

    public void connectOutput(int n, SynthInput synthInput, int n2) throws SynthException {
        MultiplyAddUnit multiplyAddUnit = this.nodes[this.numInputs - 1][n];
        multiplyAddUnit.output.connect(0, synthInput, n2);
    }

    public void setGain(int n, int n2, double d) throws SynthException {
        MultiplyAddUnit multiplyAddUnit = this.nodes[n][n2];
        multiplyAddUnit.inputB.set(d);
    }

    public void setGain(int n, int n2, int n3, double d) throws SynthException {
        MultiplyAddUnit multiplyAddUnit = this.nodes[n2][n3];
        multiplyAddUnit.inputB.set(n, d);
    }
}

