/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn;

import com.softsynth.jsyn.CSynAudioInterface;
import com.softsynth.jsyn.CSynInterface;
import com.softsynth.jsyn.CSynNativeImplementation;
import com.softsynth.jsyn.SharedSleeper;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthObject;
import com.softsynth.jsyn.bridge.CSynErrors;
import com.softsynth.jsyn.bridge.CSynJavaImplementation;
import com.softsynth.jsyn.view102.MessageDialog;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Vector;

public class SynthContext {
    private boolean gotInputPermission = false;
    private SharedSleeper sleeper;
    private Vector trackedObjects;
    protected Vector trackingThreads;
    private double suggestedInputLatency = 0.0;
    private double suggestedOutputLatency = 0.0;
    boolean deleteByGarbageCollector = true;
    private int flags = 0;
    private int openCount;
    private double millisPerTick;
    private CSynInterface csyn;
    private static CSynAudioInterface csynAudioDevice;
    private static boolean isAppletFlag;
    private static boolean appletFlagValid;

    public SynthContext() {
        this(false);
    }

    public SynthContext(boolean bl) {
        if (bl) {
            CSynNativeImplementation cSynNativeImplementation = new CSynNativeImplementation();
            this.csyn = cSynNativeImplementation;
            if (csynAudioDevice == null) {
                csynAudioDevice = cSynNativeImplementation;
            }
        } else {
            CSynJavaImplementation cSynJavaImplementation = new CSynJavaImplementation();
            this.csyn = cSynJavaImplementation;
            if (csynAudioDevice == null) {
                csynAudioDevice = cSynJavaImplementation;
            }
        }
        this.trackedObjects = new Vector();
        this.trackingThreads = new Vector();
        this.sleeper = this.createSharedSleeper();
    }

    private void checkEngineAccess() {
        try {
            this.csyn.getVersion();
        }
        catch (Throwable throwable) {
            throw new SynthException(-204, "JSyn not properly installed, or web page is not calling smart_embed_jsyn.js!");
        }
    }

    public SharedSleeper createSharedSleeper() {
        return new SharedSleeper(){

            public synchronized int bumpIndex() {
                SynthContext.this.csyn.sleepUntilTick(SynthContext.this.getTickCount() + 1);
                return SynthContext.this.getTickCount();
            }
        };
    }

    public synchronized void delete() {
        if (this.getOpenCount() <= 0) {
            this.csyn.delete();
            this.setOpenCount(0);
        }
    }

    public int debug() {
        return this.debug(1, 0);
    }

    public int debug(int n, int n2) {
        return this.csyn.debug(n, n2);
    }

    public static int errorCodeToText(int n, byte[] byArray, int n2) {
        String string = CSynErrors.errorCodeToText(n);
        byte[] byArray2 = string.getBytes();
        System.arraycopy(byArray2, 0, byArray, 0, string.length());
        return string.length();
    }

    public double getUsage() {
        return this.csyn.getUsage();
    }

    public int getObjectCount() {
        return this.csyn.getObjectCount();
    }

    public int getFrameCount() {
        return this.csyn.getFrameCount();
    }

    public int getTickCount() {
        return this.csyn.getTickCount();
    }

    public int getFramesPerTick() {
        return this.csyn.getFramesPerTick();
    }

    public double getFrameRate() {
        return this.csyn.getFrameRate();
    }

    public double getTickRate() {
        return this.csyn.getTickRate();
    }

    public int createUnit(int n, int n2, int n3) {
        return this.csyn.createUnit(n, n2, n3);
    }

    public int stopUnit(int n) {
        return this.csyn.stopUnit(n);
    }

    public int startUnit(int n) {
        return this.csyn.startUnit(n);
    }

    public int stopUnitAt(int n, int n2) {
        return this.csyn.stopUnitAt(n, n2);
    }

    public int startUnitAt(int n, int n2) {
        return this.csyn.startUnitAt(n, n2);
    }

    public int setPort(int n, int n2, int n3, double d) {
        return this.csyn.setPort(n, n2, n3, d);
    }

    public int setPortAt(int n, int n2, int n3, int n4, double d) {
        return this.csyn.setPortAt(n, n2, n3, n4, d);
    }

    public double getPort(int n, int n2, int n3) {
        return this.csyn.getPort(n, n2, n3);
    }

    public int setPortSignalType(int n, int n2, int n3, int n4) {
        return this.csyn.setPortSignalType(n, n2, n3, n4);
    }

    public int getPortSignalType(int n, int n2, int n3) {
        return this.csyn.getPortSignalType(n, n2, n3);
    }

    public int getNumParts(int n, int n2) {
        return this.csyn.getNumParts(n, n2);
    }

    public int connectUnits(int n, int n2, int n3, int n4, int n5, int n6) {
        return this.csyn.connectUnits(n, n2, n3, n4, n5, n6);
    }

    public int disconnectUnits(int n, int n2, int n3) {
        return this.csyn.disconnectUnits(n, n2, n3);
    }

    public int setPriority(int n, int n2) {
        return this.csyn.setPriority(n, n2);
    }

    public int getPriority(int n) {
        return this.csyn.getPriority(n);
    }

    public int createTable(int n) {
        return this.csyn.createTable(n);
    }

    public int writeTable(int n, int n2, int n3, short[] sArray, int n4, int n5) {
        return this.csyn.writeTable(n, n2, n3, sArray, n4, n5);
    }

    public int writeTableDoubles(int n, int n2, int n3, double[] dArray, int n4, int n5) {
        return this.csyn.writeTableDoubles(n, n2, n3, dArray, n4, n5);
    }

    public int useTable(int n, int n2, int n3, int n4) {
        return this.csyn.useTable(n, n2, n3, n4);
    }

    public int createEnvelope(int n) {
        return this.csyn.createEnvelope(n);
    }

    public int writeEnvelope(int n, int n2, int n3, double[] dArray, int n4, int n5) {
        return this.csyn.writeEnvelope(n, n2, n3, dArray, n4, n5);
    }

    public int readEnvelope(int n, int n2, int n3, double[] dArray, int n4, int n5) {
        return this.csyn.readEnvelope(n, n2, n3, dArray, n4, n5);
    }

    public int createSample(int n, int n2) {
        return this.csyn.createSample(n, n2);
    }

    public int writeSample(int n, int n2, int n3, short[] sArray, int n4, int n5) {
        return this.csyn.writeSample(n, n2, n3, sArray, n4, n5);
    }

    public int readSample(int n, int n2, int n3, short[] sArray, int n4, int n5) {
        return this.csyn.readSample(n, n2, n3, sArray, n4, n5);
    }

    public int clearDataQueue(int n, int n2) {
        return this.csyn.clearDataQueue(n, n2);
    }

    public int clearDataQueueAt(int n, int n2, int n3) {
        return this.csyn.clearDataQueueAt(n, n2, n3);
    }

    public int queueData(int n, int n2, int n3, int n4, int n5, int n6) {
        return this.csyn.queueData(n, n2, n3, n4, n5, n6);
    }

    public int queueDataAt(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        return this.csyn.queueDataAt(n, n2, n3, n4, n5, n6, n7);
    }

    public int getPortFrames(int n, int n2, int n3) {
        return this.csyn.getPortFrames(n, n2, n3);
    }

    public void sleepUntilTick(int n) throws SynthException {
        if ((this.getFlags() & 4) != 0) {
            try {
                this.sleeper.addThread();
                this.sleeper.sleepUntilIndex(n);
            }
            catch (InterruptedException interruptedException) {}
        } else {
            int n2 = (int)(this.getTickRate() / 2.0);
            if (n2 < 1) {
                throw new SynthException("getTickRate() = " + this.getTickRate());
            }
            int n3 = n - this.getTickCount();
            if (this.getOpenCount() == 0) {
                return;
            }
            try {
                while (n3 > 0) {
                    int n4 = n3 > n2 ? n2 / 2 : n3;
                    int n5 = (int)((double)n4 * this.getMillisPerTick()) + 1;
                    Thread.sleep(n5);
                    if (this.getOpenCount() <= 0) {
                        throw new SynthException("Engine stopped.");
                    }
                    this.checkEngineErrors();
                    n3 = n - this.getTickCount();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void checkEngineErrors() throws SynthException {
        this.csyn.checkEngineErrors();
    }

    public void sleepForTicks(int n) throws SynthException {
        this.sleepUntilTick(n + this.getTickCount());
    }

    public synchronized void startEngine(int n, double d) throws SynthException {
        this.initialize();
        this.start(n, d);
    }

    protected final boolean askInputPermission() {
        MessageDialog messageDialog = new MessageDialog("This Java Applet is requesting permission to turn on the\nmicrophone or other audio input.\nPress OK to grant permission.", "OK", "DENY");
        return messageDialog.ask() == 0;
    }

    public synchronized void start(int n, double d, int n2, int n3, int n4, int n5) throws SynthException {
        if (n2 != -1) {
            n |= 0x20;
        }
        if (n4 == -1) {
            n |= 0x40;
        }
        this.setFlags(n);
        if ((n & 0x20) != 0 && !this.gotInputPermission && SynthContext.isApplet()) {
            if (this.askInputPermission()) {
                this.gotInputPermission = true;
            } else {
                throw new SecurityException("Access to microphone denied by user.");
            }
        }
        this.sleeper.setIndex(this.getTickCount());
        this.csyn.startDevices(n, d, n2, n3, n4, n5);
        this.setMillisPerTick(1000.0 / this.getTickRate());
        if (Synth.verbosity > 1) {
            System.out.println("JSyn: V" + Synth.getVersion() + ", frame rate = " + this.getFrameRate());
        }
    }

    public void start(int n, double d) throws SynthException {
        this.start(n, d, (n & 0x20) != 0 ? SynthContext.getDefaultInputDeviceID() : -1, (n & 0x20) != 0 ? 2 : 0, (n & 0x40) == 0 ? SynthContext.getDefaultOutputDeviceID() : -1, (n & 0x40) == 0 ? 2 : 0);
    }

    public void start(int n) throws SynthException {
        this.start(n, 44100.0);
    }

    public SharedSleeper getSleeper() {
        return this.sleeper;
    }

    public synchronized void initialize() throws SynthException {
        this.gotInputPermission = false;
        System.out.println("  java.version = " + System.getProperty("java.version") + ", java.vendor = " + System.getProperty("java.vendor") + ", os.arch = " + System.getProperty("os.arch"));
        int n = Synth.getVersion();
        if (n != 154) {
            System.err.println("Version mismatch! Java = 154, 'native = " + n);
            throw new SynthException(-201, n);
        }
        this.csyn.initialize();
        this.setOpenCount(this.getOpenCount() + 1);
    }

    public void startEngine(int n) throws SynthException {
        this.startEngine(n, 44100.0);
    }

    public synchronized void stopEngine() throws SynthException {
        this.stop();
        this.terminate();
    }

    public synchronized void stop() throws SynthException {
        if (this.sleeper != null) {
            this.sleeper.removeThread();
        }
        this.csyn.stop();
    }

    public synchronized void terminate() throws SynthException {
        if (Synth.verbosity > 1) {
            System.out.println("SynthContext.terminate() called.");
        }
        this.deleteAll();
        this.setOpenCount(this.getOpenCount() - 1);
        this.csyn.terminate();
    }

    void reclaim() {
        Runtime runtime = Runtime.getRuntime();
        int n = 0;
        int n2 = this.getObjectCount();
        while (n2 != n) {
            n = n2;
            runtime.gc();
            System.out.println("reclaim() - num = " + n2);
            n2 = this.getObjectCount();
        }
        runtime.runFinalization();
    }

    public int createCircuit(int[] nArray, int n) throws SynthException {
        int n2 = nArray.length;
        int n3 = this.csyn.createCircuit(nArray, n2, n);
        if (n3 < 0) {
            throw new SynthException(n3, n2);
        }
        return n3;
    }

    public int delete(SynthObject synthObject) {
        if (this.getOpenCount() > 0) {
            return this.csyn.delete(synthObject.getPeer());
        }
        return 0;
    }

    public boolean isTrackingEnabled() {
        return this.trackingThreads.contains(Thread.currentThread());
    }

    public void enableTracking(boolean bl) {
        if (bl) {
            this.trackingThreads.addElement(Thread.currentThread());
        } else {
            this.trackingThreads.removeElement(Thread.currentThread());
        }
    }

    public void track(SynthObject synthObject) {
        this.trackedObjects.addElement(synthObject);
    }

    public void unTrack(SynthObject synthObject) {
        this.trackedObjects.removeElement(synthObject);
    }

    public synchronized void deleteAll() throws SynthException {
        SynthObject synthObject = null;
        while (!this.trackedObjects.isEmpty()) {
            SynthObject synthObject2 = (SynthObject)this.trackedObjects.lastElement();
            if (synthObject2 == synthObject) {
                throw new SynthException("deleteAll: deleting same object twice = " + synthObject2);
            }
            synthObject2.delete();
            synthObject = synthObject2;
        }
        this.trackingThreads.removeAllElements();
    }

    public void enableDeletionByGarbageCollector(boolean bl) {
        this.deleteByGarbageCollector = bl;
    }

    public void setTrace(int n) {
        Synth.verbosity = n;
        this.csyn.setTrace(n);
    }

    public int getTrace() {
        return this.csyn.getTrace();
    }

    static int getNumDevices() {
        int n = csynAudioDevice.getNumDevices();
        if (n <= 0) {
            throw new SynthException("SynthContext must be initialized before calling getNumDevices().");
        }
        return n;
    }

    static int getDefaultInputDeviceID() {
        return csynAudioDevice.getDefaultInputDeviceID();
    }

    static int getDefaultOutputDeviceID() {
        return csynAudioDevice.getDefaultOutputDeviceID();
    }

    static int getMaxInputChannels(int n) {
        return csynAudioDevice.getMaxInputChannels(n);
    }

    static int getMaxOutputChannels(int n) {
        return csynAudioDevice.getMaxOutputChannels(n);
    }

    static String getDeviceName(int n) {
        byte[] byArray = new byte[256];
        int n2 = csynAudioDevice.getDeviceName(n, byArray, byArray.length);
        if (n2 < 1) {
            throw new SynthException(n2, "could not get device name");
        }
        return new String(byArray, 0, 0, n2);
    }

    public static boolean isApplet() {
        if (appletFlagValid) {
            return isAppletFlag;
        }
        try {
            FileInputStream fileInputStream = new FileInputStream("nonExistantFile.txt");
            fileInputStream.close();
            isAppletFlag = false;
        }
        catch (SecurityException securityException) {
            isAppletFlag = true;
        }
        catch (IOException iOException) {
            isAppletFlag = false;
        }
        appletFlagValid = true;
        return isAppletFlag;
    }

    public int setSuggestedInputLatency(double d) {
        this.suggestedInputLatency = d;
        return csynAudioDevice.setSuggestedInputLatency(d);
    }

    public int setSuggestedOutputLatency(double d) {
        this.suggestedOutputLatency = d;
        return csynAudioDevice.setSuggestedOutputLatency(d);
    }

    public double getOutputLatency() {
        return csynAudioDevice.getOutputLatency();
    }

    public double getInputLatency() {
        return csynAudioDevice.getInputLatency();
    }

    public void setFlags(int n) {
        this.flags = n;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setMillisPerTick(double d) {
        this.millisPerTick = d;
    }

    public double getMillisPerTick() {
        return this.millisPerTick;
    }

    public void setOpenCount(int n) {
        this.openCount = n;
    }

    public int getOpenCount() {
        return this.openCount;
    }

    static {
        isAppletFlag = true;
        appletFlagValid = false;
    }
}

