/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn;

import com.softsynth.jsyn.ChunkHandler;
import com.softsynth.jsyn.Synth;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class ParseIFF {
    InputStream stream;
    long offset = 0L;
    long totalSize = 0L;
    public static final int LIST_ID = 1279873876;
    public static final int FORM_ID = 1179603533;

    public ParseIFF(InputStream inputStream) {
        this.stream = inputStream;
        this.offset = 0L;
    }

    public long getFileSize() {
        return this.totalSize;
    }

    public long getOffset() {
        return this.offset;
    }

    public int read() throws IOException {
        ++this.offset;
        return this.stream.read();
    }

    public int read(byte[] byArray) throws IOException {
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = this.stream.read(byArray, n2, n - n2);
            if (n3 < 0) {
                return n3;
            }
            n2 += n3;
            this.offset += (long)n3;
        }
        return n2;
    }

    public long skip(long l) throws IOException {
        long l2 = l;
        while (l2 > 0L) {
            long l3 = this.stream.skip(l2);
            if (l3 < 0L) {
                return l3;
            }
            l2 -= l3;
            this.offset += l3;
        }
        return l;
    }

    public int readIntBig() throws IOException {
        int n = this.read() & 0xFF;
        n = n << 8 | this.read() & 0xFF;
        n = n << 8 | this.read() & 0xFF;
        int n2 = this.read();
        if (n2 == -1) {
            throw new EOFException("readIntBig() - EOF in middle of word at offset " + this.offset);
        }
        n = n << 8 | n2 & 0xFF;
        return n;
    }

    public short readShortBig() throws IOException {
        short s = (short)(this.read() << 8);
        int n = this.read();
        if (n == -1) {
            throw new EOFException("readShortBig() - EOF in middle of word at offset " + this.offset);
        }
        s = (short)(s | n & 0xFF);
        return s;
    }

    public int readIntLittle() throws IOException {
        int n = this.read() & 0xFF;
        n |= (this.read() & 0xFF) << 8;
        n |= (this.read() & 0xFF) << 16;
        int n2 = this.read();
        if (n2 == -1) {
            throw new EOFException("readIntLittle() - EOF in middle of word at offset " + this.offset);
        }
        return n |= n2 << 24;
    }

    public short readShortLittle() throws IOException {
        short s = (short)(this.read() & 0xFF);
        int n = this.read();
        if (n == -1) {
            throw new EOFException("readShortLittle() - EOF in middle of word at offset " + this.offset);
        }
        s = (short)(s | n << 8);
        return s;
    }

    public byte readByte() throws IOException {
        return (byte)this.read();
    }

    public int readChunkSize() throws IOException {
        return this.readIntBig();
    }

    public static String IDToString(int n) {
        byte[] byArray = new byte[]{(byte)(n >> 24), (byte)(n >> 16), (byte)(n >> 8), (byte)n};
        return new String(byArray, 0);
    }

    public void parse(ChunkHandler chunkHandler) throws IOException {
        if (Synth.verbosity > 1) {
            System.out.println("parse() ------- begin");
        }
        this.offset = 0L;
        int n = this.readIntBig();
        int n2 = this.readChunkSize();
        this.totalSize = n2 + 8;
        this.parseChunk(chunkHandler, n, n2);
        if (Synth.verbosity > 1) {
            System.out.println("parse() ------- end");
        }
    }

    void parseForm(ChunkHandler chunkHandler, int n, int n2, int n3) throws IOException {
        while (n2 > 0) {
            int n4 = this.readIntBig();
            int n5 = this.readChunkSize();
            n2 -= 8;
            if (n5 <= 0) {
                throw new IOException("Bad IFF format. " + ParseIFF.IDToString(n4) + ", Size = " + n5);
            }
            this.parseChunk(chunkHandler, n4, n5);
            if ((n5 & 1) == 1) {
                ++n5;
            }
            n2 -= n5;
        }
    }

    public boolean isForm(int n) throws IOException {
        switch (n) {
            case 1179603533: 
            case 1279873876: {
                return true;
            }
        }
        return false;
    }

    void parseChunk(ChunkHandler chunkHandler, int n, int n2) throws IOException {
        int n3;
        long l;
        if (Synth.verbosity > 1) {
            System.out.println("parseChunk( " + ParseIFF.IDToString(n) + ", " + n2 + " )");
        }
        long l2 = this.getOffset();
        if (this.isForm(n)) {
            int n4 = this.readIntBig();
            chunkHandler.handleForm(this, n, n2 - 4, n4);
            l = this.getOffset();
            n3 = (int)(l - l2);
            if (n3 < n2) {
                this.parseForm(chunkHandler, n, n2 - n3, n4);
            }
        } else {
            chunkHandler.handleChunk(this, n, n2);
        }
        l = this.getOffset();
        n3 = (int)(l - l2);
        if ((n2 & 1) == 1) {
            ++n2;
        }
        if (n3 < n2) {
            this.skip(n2 - n3);
        }
    }
}

