/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn;

import com.jsyn.data.SegmentedEnvelope;
import java.util.Vector;

public class EnvelopePoints
extends Vector {
    String name = "";
    double maximumValue = 1.0;
    int sustainBegin = -1;
    int sustainEnd = -1;
    int releaseBegin = -1;
    int releaseEnd = -1;

    public void updateEnvelope(SegmentedEnvelope segmentedEnvelope) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            segmentedEnvelope.write(i, this.getPoint(i), 0, 1);
        }
        segmentedEnvelope.setSustainBegin(this.getSustainBegin());
        segmentedEnvelope.setSustainEnd(this.getSustainEnd());
        segmentedEnvelope.setReleaseBegin(this.getReleaseBegin());
        segmentedEnvelope.setReleaseEnd(this.getReleaseEnd());
        segmentedEnvelope.setNumFrames(n);
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void setMaximumValue(double d) {
        this.maximumValue = d;
    }

    public double getMaximumValue() {
        return this.maximumValue;
    }

    public void add(double d, double d2) {
        double[] dArray = new double[]{d, d2};
        this.addElement(dArray);
    }

    public void insert(int n, double d, double d2) {
        double[] dArray = new double[]{d, d2};
        if (n < this.size()) {
            double[] dArray2 = (double[])this.elementAt(n);
            dArray2[0] = dArray2[0] - d;
        }
        this.insertElementAt(dArray, n);
        if (n <= this.sustainBegin) {
            ++this.sustainBegin;
        }
        if (n <= this.sustainEnd) {
            ++this.sustainEnd;
        }
        if (n <= this.releaseBegin) {
            ++this.releaseBegin;
        }
        if (n <= this.releaseEnd) {
            ++this.releaseEnd;
        }
    }

    public void removePoint(int n) {
        super.removeElementAt(n);
        if (n < this.sustainBegin) {
            --this.sustainBegin;
        }
        if (n <= this.sustainEnd) {
            --this.sustainEnd;
        }
        if (n < this.releaseBegin) {
            --this.releaseBegin;
        }
        if (n <= this.releaseEnd) {
            --this.releaseEnd;
        }
        if (this.sustainBegin > this.sustainEnd) {
            this.sustainBegin = -1;
            this.sustainEnd = -1;
        }
        if (this.releaseBegin > this.releaseEnd) {
            this.releaseBegin = -1;
            this.releaseEnd = -1;
        }
    }

    public double[] getPoint(int n) {
        return (double[])this.elementAt(n);
    }

    public double getTotalDuration() {
        double d = 0.0;
        for (int i = 0; i < this.size(); ++i) {
            double[] dArray = (double[])this.elementAt(i);
            d += dArray[0];
        }
        return d;
    }

    public void setSustainLoop(int n, int n2) {
        this.sustainBegin = n;
        this.sustainEnd = n2;
    }

    public int getSustainBegin() {
        return this.sustainBegin;
    }

    public int getSustainEnd() {
        return this.sustainEnd;
    }

    public int getSustainSize() {
        return this.sustainEnd - this.sustainBegin;
    }

    public void setReleaseLoop(int n, int n2) {
        this.releaseBegin = n;
        this.releaseEnd = n2;
    }

    public int getReleaseBegin() {
        return this.releaseBegin;
    }

    public int getReleaseEnd() {
        return this.releaseEnd;
    }

    public int getReleaseSize() {
        return this.releaseEnd - this.releaseBegin;
    }
}

