/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.util.soundfile;

import com.jsyn.data.FloatSample;
import com.jsyn.data.SampleMarker;
import com.jsyn.util.SampleLoader;
import com.jsyn.util.soundfile.AudioFileParser;
import com.jsyn.util.soundfile.ChunkHandler;
import com.jsyn.util.soundfile.IFFParser;
import java.io.EOFException;
import java.io.IOException;

class WAVEFileParser
extends AudioFileParser
implements ChunkHandler {
    static final short WAVE_FORMAT_PCM = 1;
    static final short WAVE_FORMAT_IEEE_FLOAT = 3;
    static final short WAVE_FORMAT_EXTENSIBLE = -2;
    static final byte[] KSDATAFORMAT_SUBTYPE_IEEE_FLOAT = new byte[]{3, 0, 0, 0, 0, 0, 16, 0, -128, 0, 0, -86, 0, 56, -101, 113};
    static final byte[] KSDATAFORMAT_SUBTYPE_PCM = new byte[]{1, 0, 0, 0, 0, 0, 16, 0, -128, 0, 0, -86, 0, 56, -101, 113};
    static final int WAVE_ID = 1463899717;
    static final int FMT_ID = 1718449184;
    static final int DATA_ID = 1684108385;
    static final int CUE_ID = 1668637984;
    static final int FACT_ID = 1717658484;
    static final int SMPL_ID = 1936552044;
    static final int LTXT_ID = 1819572340;
    static final int LABL_ID = 1818321516;
    int samplesPerBlock = 0;
    int blockAlign = 0;
    private int numFactSamples = 0;
    private short format;

    WAVEFileParser() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    FloatSample finish() throws IOException {
        if (this.byteData == null) {
            throw new IOException("No data found in audio sample.");
        }
        float[] fArray = new float[this.numFrames * this.samplesPerFrame];
        if (this.bitsPerSample == 16) {
            SampleLoader.decodeLittleI16ToF32(this.byteData, 0, this.byteData.length, fArray, 0);
            return this.makeSample(fArray);
        } else if (this.bitsPerSample == 24) {
            SampleLoader.decodeLittleI24ToF32(this.byteData, 0, this.byteData.length, fArray, 0);
            return this.makeSample(fArray);
        } else {
            if (this.bitsPerSample != 32) throw new IOException("WAV: Unsupported bitsPerSample = " + this.bitsPerSample);
            if (this.format == 3) {
                SampleLoader.decodeLittleF32ToF32(this.byteData, 0, this.byteData.length, fArray, 0);
                return this.makeSample(fArray);
            } else {
                if (this.format != 1) throw new IOException("WAV: Unsupported format = " + this.format);
                SampleLoader.decodeLittleI32ToF32(this.byteData, 0, this.byteData.length, fArray, 0);
            }
        }
        return this.makeSample(fArray);
    }

    void parseCueChunk(IFFParser iFFParser, int n) throws IOException {
        int n2 = iFFParser.readIntLittle();
        if (IFFParser.debug) {
            System.out.println("WAV: numCuePoints = " + n2);
        }
        if (n - 4 != 24 * n2) {
            throw new EOFException("Cue chunk too short!");
        }
        for (int i = 0; i < n2; ++i) {
            int n3 = iFFParser.readIntLittle();
            int n4 = iFFParser.readIntLittle();
            iFFParser.skip(12L);
            int n5 = iFFParser.readIntLittle();
            if (IFFParser.debug) {
                System.out.println("WAV: parseCueChunk: #" + i + ", dwPosition = " + n4 + ", dwName = " + n3 + ", dwSampleOffset = " + n5);
            }
            SampleMarker sampleMarker = this.findOrCreateCuePoint(n3);
            sampleMarker.position = n4;
        }
    }

    void parseLablChunk(IFFParser iFFParser, int n) throws IOException {
        int n2 = iFFParser.readIntLittle();
        int n3 = n - 4 - 1;
        String string = this.parseString(iFFParser, n3);
        if (IFFParser.debug) {
            System.out.println("WAV: label id = " + n2 + ", text = " + string);
        }
        SampleMarker sampleMarker = this.findOrCreateCuePoint(n2);
        sampleMarker.name = string;
    }

    void parseLtxtChunk(IFFParser iFFParser, int n) throws IOException {
        int n2 = iFFParser.readIntLittle();
        int n3 = iFFParser.readIntLittle();
        iFFParser.skip(12L);
        int n4 = n - 24 - 1;
        if (n4 > 0) {
            String string = this.parseString(iFFParser, n4);
            if (IFFParser.debug) {
                System.out.println("WAV: ltxt id = " + n2 + ", dwSampleLength = " + n3 + ", text = " + string);
            }
            SampleMarker sampleMarker = this.findOrCreateCuePoint(n2);
            sampleMarker.comment = string;
        }
    }

    void parseFmtChunk(IFFParser iFFParser, int n) throws IOException {
        this.format = iFFParser.readShortLittle();
        this.samplesPerFrame = iFFParser.readShortLittle();
        this.frameRate = iFFParser.readIntLittle();
        iFFParser.readIntLittle();
        this.blockAlign = iFFParser.readShortLittle();
        this.bitsPerSample = iFFParser.readShortLittle();
        if (IFFParser.debug) {
            System.out.println("WAV: format = 0x" + Integer.toHexString(this.format));
            System.out.println("WAV: bitsPerSample = " + this.bitsPerSample);
            System.out.println("WAV: samplesPerFrame = " + this.samplesPerFrame);
        }
        this.bytesPerFrame = this.blockAlign;
        this.bytesPerSample = this.bytesPerFrame / this.samplesPerFrame;
        this.samplesPerBlock = 8 * this.blockAlign / this.bitsPerSample;
        if (this.format == -2) {
            short s = iFFParser.readShortLittle();
            short s2 = iFFParser.readShortLittle();
            int n2 = iFFParser.readIntLittle();
            byte[] byArray = new byte[16];
            iFFParser.read(byArray);
            if (IFFParser.debug) {
                System.out.println("WAV: extraSize = " + s);
                System.out.println("WAV: validBitsPerSample = " + s2);
                System.out.println("WAV: channelMask = " + n2);
                System.out.print("guid = {");
                for (int i = 0; i < byArray.length; ++i) {
                    System.out.print(byArray[i] + ", ");
                }
                System.out.println("}");
            }
            if (this.matchBytes(byArray, KSDATAFORMAT_SUBTYPE_IEEE_FLOAT)) {
                this.format = (short)3;
            } else if (this.matchBytes(byArray, KSDATAFORMAT_SUBTYPE_PCM)) {
                this.format = 1;
            }
        }
        if (this.format != 1 && this.format != 3) {
            throw new IOException("Only WAVE_FORMAT_PCM and WAVE_FORMAT_IEEE_FLOAT supported. format = " + this.format);
        }
        if (this.bitsPerSample != 16 && this.bitsPerSample != 24 && this.bitsPerSample != 32) {
            throw new IOException("Only 16 and 24 bit PCM or 32-bit float WAV files supported. width = " + this.bitsPerSample);
        }
    }

    private boolean matchBytes(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    private int convertByteToFrame(int n) throws IOException {
        if (this.blockAlign == 0) {
            throw new IOException("WAV file has bytesPerBlock = zero");
        }
        if (this.samplesPerFrame == 0) {
            throw new IOException("WAV file has samplesPerFrame = zero");
        }
        int n2 = this.samplesPerBlock * n / (this.samplesPerFrame * this.blockAlign);
        return n2;
    }

    private int calculateNumFrames(int n) throws IOException {
        int n2 = this.numFactSamples > 0 ? this.numFactSamples : this.convertByteToFrame(n);
        return n2;
    }

    private double readFraction(IFFParser iFFParser) throws IOException {
        long l = 0xFFFFFFFFL;
        long l2 = (long)iFFParser.readIntLittle() & l;
        return (double)l2 / (double)l;
    }

    void parseSmplChunk(IFFParser iFFParser, int n) throws IOException {
        iFFParser.readIntLittle();
        iFFParser.readIntLittle();
        iFFParser.readIntLittle();
        int n2 = iFFParser.readIntLittle();
        double d = this.readFraction(iFFParser);
        this.originalPitch = (double)n2 + d;
        iFFParser.readIntLittle();
        iFFParser.readIntLittle();
        int n3 = iFFParser.readIntLittle();
        iFFParser.readIntLittle();
        int n4 = Integer.MAX_VALUE;
        for (int i = 0; i < n3; ++i) {
            int n5 = iFFParser.readIntLittle();
            iFFParser.readIntLittle();
            int n6 = iFFParser.readIntLittle();
            int n7 = iFFParser.readIntLittle() + 1;
            double d2 = this.readFraction(iFFParser);
            iFFParser.readIntLittle();
            if (n5 >= n4) continue;
            this.sustainBegin = n6;
            this.sustainEnd = n7;
        }
    }

    void parseFactChunk(IFFParser iFFParser, int n) throws IOException {
        this.numFactSamples = iFFParser.readIntLittle();
    }

    void parseDataChunk(IFFParser iFFParser, int n) throws IOException {
        long l;
        this.dataPosition = iFFParser.getOffset();
        if (this.ifLoadData) {
            this.byteData = new byte[n];
            l = iFFParser.read(this.byteData);
        } else {
            l = iFFParser.skip(n);
        }
        if (l != (long)n) {
            throw new EOFException("WAV data chunk too short! Read " + l + " instead of " + n);
        }
        this.numFrames = this.calculateNumFrames(n);
    }

    public void handleForm(IFFParser iFFParser, int n, int n2, int n3) throws IOException {
        if (n == 1380533830 && n3 != 1463899717) {
            throw new IOException("Bad WAV form type = " + IFFParser.IDToString(n3));
        }
    }

    public void handleChunk(IFFParser iFFParser, int n, int n2) throws IOException {
        switch (n) {
            case 1718449184: {
                this.parseFmtChunk(iFFParser, n2);
                break;
            }
            case 1684108385: {
                this.parseDataChunk(iFFParser, n2);
                break;
            }
            case 1668637984: {
                this.parseCueChunk(iFFParser, n2);
                break;
            }
            case 1717658484: {
                this.parseFactChunk(iFFParser, n2);
                break;
            }
            case 1936552044: {
                this.parseSmplChunk(iFFParser, n2);
                break;
            }
            case 1818321516: {
                this.parseLablChunk(iFFParser, n2);
                break;
            }
            case 1819572340: {
                this.parseLtxtChunk(iFFParser, n2);
                break;
            }
        }
    }

    boolean isLittleEndian() {
        return true;
    }
}

