/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.util.soundfile;

import com.jsyn.data.FloatSample;
import com.jsyn.util.AudioSampleLoader;
import com.jsyn.util.soundfile.AIFFFileParser;
import com.jsyn.util.soundfile.AudioFileParser;
import com.jsyn.util.soundfile.IFFParser;
import com.jsyn.util.soundfile.WAVEFileParser;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class CustomSampleLoader
implements AudioSampleLoader {
    public FloatSample loadFloatSample(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
        return this.loadFloatSample(bufferedInputStream);
    }

    public FloatSample loadFloatSample(URL uRL) throws IOException {
        InputStream inputStream = uRL.openStream();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        return this.loadFloatSample(bufferedInputStream);
    }

    public FloatSample loadFloatSample(InputStream inputStream) throws IOException {
        AudioFileParser audioFileParser;
        IFFParser iFFParser = new IFFParser(inputStream);
        iFFParser.readHead();
        if (iFFParser.isRIFF()) {
            audioFileParser = new WAVEFileParser();
        } else if (iFFParser.isIFF()) {
            audioFileParser = new AIFFFileParser();
        } else {
            throw new IOException("Unsupported audio file type.");
        }
        return audioFileParser.load(iFFParser);
    }
}

