/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.util.soundfile;

import com.jsyn.data.FloatSample;
import com.jsyn.data.SampleMarker;
import com.jsyn.util.SampleLoader;
import com.jsyn.util.soundfile.AudioFileParser;
import com.jsyn.util.soundfile.IFFParser;
import java.io.EOFException;
import java.io.IOException;

public class AIFFFileParser
extends AudioFileParser {
    private static final String SUPPORTED_FORMATS = "Only 16 and 24 bit PCM or 32-bit float AIF files supported.";
    static final int AIFF_ID = 1095321158;
    static final int AIFC_ID = 1095321155;
    static final int COMM_ID = 1129270605;
    static final int SSND_ID = 1397968452;
    static final int MARK_ID = 1296126539;
    static final int INST_ID = 1229869908;
    static final int NONE_ID = 1313820229;
    static final int FL32_ID = 1179398962;
    static final int FL32_ID_LC = 1718367026;
    int sustainBeginID = -1;
    int sustainEndID = -1;
    int releaseBeginID = -1;
    int releaseEndID = -1;
    boolean typeFloat = false;

    FloatSample finish() throws IOException {
        this.setLoops();
        if (this.byteData == null) {
            throw new IOException("No data found in audio sample.");
        }
        float[] fArray = new float[this.numFrames * this.samplesPerFrame];
        if (this.bitsPerSample == 16) {
            SampleLoader.decodeBigI16ToF32(this.byteData, 0, this.byteData.length, fArray, 0);
        } else if (this.bitsPerSample == 24) {
            SampleLoader.decodeBigI24ToF32(this.byteData, 0, this.byteData.length, fArray, 0);
        } else if (this.bitsPerSample == 32) {
            if (this.typeFloat) {
                SampleLoader.decodeBigF32ToF32(this.byteData, 0, this.byteData.length, fArray, 0);
            } else {
                SampleLoader.decodeBigI32ToF32(this.byteData, 0, this.byteData.length, fArray, 0);
            }
        } else {
            throw new IOException("Only 16 and 24 bit PCM or 32-bit float AIF files supported. size = " + this.bitsPerSample);
        }
        return this.makeSample(fArray);
    }

    double read80BitFloat() throws IOException {
        byte[] byArray = new byte[10];
        this.parser.read(byArray);
        int n = (byArray[0] & 0x3F) << 8 | byArray[1] & 0xFF;
        int n2 = (byArray[2] & 0xFF) << 16 | (byArray[3] & 0xFF) << 8 | byArray[4] & 0xFF;
        return (double)n2 / (double)(1 << 22 - n);
    }

    void parseCOMMChunk(IFFParser iFFParser, int n) throws IOException {
        this.samplesPerFrame = iFFParser.readShortBig();
        this.numFrames = iFFParser.readIntBig();
        this.bitsPerSample = iFFParser.readShortBig();
        this.frameRate = this.read80BitFloat();
        if (n > 18) {
            int n2 = iFFParser.readIntBig();
            if (n2 == 1179398962 || n2 == 1718367026) {
                this.typeFloat = true;
            } else if (n2 == 1313820229) {
                this.typeFloat = false;
            } else {
                throw new IOException("Only 16 and 24 bit PCM or 32-bit float AIF files supported. format " + IFFParser.IDToString(n2));
            }
        }
        this.bytesPerSample = (this.bitsPerSample + 7) / 8;
        this.bytesPerFrame = this.bytesPerSample * this.samplesPerFrame;
    }

    void parseINSTChunk(IFFParser iFFParser, int n) throws IOException {
        byte by = iFFParser.readByte();
        byte by2 = iFFParser.readByte();
        this.originalPitch = (double)by + 0.01 * (double)by2;
        byte by3 = iFFParser.readByte();
        byte by4 = iFFParser.readByte();
        iFFParser.skip(2L);
        short s = iFFParser.readShortBig();
        short s2 = iFFParser.readShortBig();
        this.sustainBeginID = iFFParser.readShortBig();
        this.sustainEndID = iFFParser.readShortBig();
        s2 = iFFParser.readShortBig();
        this.releaseBeginID = iFFParser.readShortBig();
        this.releaseEndID = iFFParser.readShortBig();
    }

    private void setLoops() {
        SampleMarker sampleMarker = (SampleMarker)this.cueMap.get(this.sustainBeginID);
        if (sampleMarker != null) {
            this.sustainBegin = sampleMarker.position;
        }
        if ((sampleMarker = (SampleMarker)this.cueMap.get(this.sustainEndID)) != null) {
            this.sustainEnd = sampleMarker.position;
        }
    }

    void parseSSNDChunk(IFFParser iFFParser, int n) throws IOException {
        long l;
        int n2 = iFFParser.readIntBig();
        iFFParser.readIntBig();
        iFFParser.skip(n2);
        this.dataPosition = iFFParser.getOffset();
        int n3 = n - 8 - n2;
        if (this.ifLoadData) {
            this.byteData = new byte[n3];
            l = iFFParser.read(this.byteData);
        } else {
            l = iFFParser.skip(n3);
        }
        if (l != (long)n3) {
            throw new EOFException("AIFF data chunk too short!");
        }
    }

    void parseMARKChunk(IFFParser iFFParser, int n) throws IOException {
        long l = iFFParser.getOffset();
        int n2 = iFFParser.readShortBig();
        for (int i = 0; i < n2; ++i) {
            long l2 = iFFParser.getOffset() - l;
            if (l2 >= (long)n) {
                System.out.println("Reached end of MARK chunk with bogus numCuePoints = " + n2);
                break;
            }
            short s = iFFParser.readShortBig();
            int n3 = iFFParser.readIntBig();
            int n4 = iFFParser.read();
            String string = this.parseString(iFFParser, n4);
            if ((n4 & 1) == 0) {
                iFFParser.skip(1L);
            }
            SampleMarker sampleMarker = this.findOrCreateCuePoint(s);
            sampleMarker.position = n3;
            sampleMarker.name = string;
            if (!IFFParser.debug) continue;
            System.out.println("AIFF Marker at " + n3 + ", " + string);
        }
    }

    public void handleForm(IFFParser iFFParser, int n, int n2, int n3) throws IOException {
        if (n == 1179603533 && n3 != 1095321158 && n3 != 1095321155) {
            throw new IOException("Bad AIFF form type = " + IFFParser.IDToString(n3));
        }
    }

    public void handleChunk(IFFParser iFFParser, int n, int n2) throws IOException {
        switch (n) {
            case 1129270605: {
                this.parseCOMMChunk(iFFParser, n2);
                break;
            }
            case 1397968452: {
                this.parseSSNDChunk(iFFParser, n2);
                break;
            }
            case 1296126539: {
                this.parseMARKChunk(iFFParser, n2);
                break;
            }
            case 1229869908: {
                this.parseINSTChunk(iFFParser, n2);
                break;
            }
        }
    }
}

