/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.util;

import com.jsyn.Synthesizer;
import com.jsyn.unitgen.UnitVoice;
import com.jsyn.util.Instrument;
import com.softsynth.shared.time.ScheduledCommand;
import com.softsynth.shared.time.TimeStamp;

public class VoiceAllocator
implements Instrument {
    private int maxVoices;
    private VoiceTracker[] trackers;
    private long tick;
    private Synthesizer synthesizer;
    private int presetIndex = -1;

    public VoiceAllocator(UnitVoice[] unitVoiceArray) {
        this.maxVoices = unitVoiceArray.length;
        this.trackers = new VoiceTracker[this.maxVoices];
        for (int i = 0; i < this.maxVoices; ++i) {
            this.trackers[i] = new VoiceTracker();
            this.trackers[i].voice = unitVoiceArray[i];
        }
    }

    public Synthesizer getSynthesizer() {
        if (this.synthesizer == null) {
            this.synthesizer = this.trackers[0].voice.getUnitGenerator().getSynthesizer();
        }
        return this.synthesizer;
    }

    public int getVoiceCount() {
        return this.maxVoices;
    }

    private VoiceTracker findVoice(int n) {
        for (VoiceTracker voiceTracker : this.trackers) {
            if (voiceTracker.tag != n) continue;
            return voiceTracker;
        }
        return null;
    }

    private VoiceTracker stealVoice() {
        VoiceTracker voiceTracker = null;
        VoiceTracker voiceTracker2 = null;
        for (VoiceTracker voiceTracker3 : this.trackers) {
            if (voiceTracker3.voice == null) {
                return voiceTracker3;
            }
            if (voiceTracker != null) {
                if (voiceTracker3.on || voiceTracker3.when >= voiceTracker.when) continue;
                voiceTracker = voiceTracker3;
                continue;
            }
            if (voiceTracker3.on) {
                if (voiceTracker2 == null) {
                    voiceTracker2 = voiceTracker3;
                    continue;
                }
                if (voiceTracker3.when >= voiceTracker2.when) continue;
                voiceTracker2 = voiceTracker3;
                continue;
            }
            voiceTracker = voiceTracker3;
        }
        if (voiceTracker != null) {
            return voiceTracker;
        }
        return voiceTracker2;
    }

    protected synchronized UnitVoice allocate(int n) {
        VoiceTracker voiceTracker = this.allocateTracker(n);
        return voiceTracker.voice;
    }

    private VoiceTracker allocateTracker(int n) {
        VoiceTracker voiceTracker = this.findVoice(n);
        if (voiceTracker == null) {
            voiceTracker = this.stealVoice();
        }
        voiceTracker.tag = n;
        voiceTracker.when = this.tick++;
        voiceTracker.on = true;
        return voiceTracker;
    }

    protected synchronized boolean isOn(int n) {
        VoiceTracker voiceTracker = this.findVoice(n);
        if (voiceTracker != null) {
            return voiceTracker.on;
        }
        return false;
    }

    protected synchronized UnitVoice off(int n) {
        VoiceTracker voiceTracker = this.findVoice(n);
        if (voiceTracker != null) {
            voiceTracker.off();
            return voiceTracker.voice;
        }
        return null;
    }

    public void allNotesOff(TimeStamp timeStamp) {
        this.getSynthesizer().scheduleCommand(timeStamp, new ScheduledCommand(){

            public void run() {
                for (VoiceTracker voiceTracker : VoiceAllocator.this.trackers) {
                    if (!voiceTracker.on) continue;
                    voiceTracker.voice.noteOff(VoiceAllocator.this.getSynthesizer().createTimeStamp());
                    voiceTracker.off();
                }
            }
        });
    }

    public void noteOn(final int n, final double d, final double d2, TimeStamp timeStamp) {
        this.getSynthesizer().scheduleCommand(timeStamp, new ScheduledCommand(){

            public void run() {
                VoiceTracker voiceTracker = VoiceAllocator.this.allocateTracker(n);
                if (VoiceAllocator.this.presetIndex != voiceTracker.presetIndex) {
                    voiceTracker.voice.usePreset(VoiceAllocator.this.presetIndex);
                }
                voiceTracker.voice.noteOn(d, d2, VoiceAllocator.this.getSynthesizer().createTimeStamp());
            }
        });
    }

    public void noteOff(final int n, TimeStamp timeStamp) {
        this.getSynthesizer().scheduleCommand(timeStamp, new ScheduledCommand(){

            public void run() {
                VoiceTracker voiceTracker = VoiceAllocator.this.findVoice(n);
                if (voiceTracker != null) {
                    voiceTracker.voice.noteOff(VoiceAllocator.this.getSynthesizer().createTimeStamp());
                    VoiceAllocator.this.off(n);
                }
            }
        });
    }

    public void setPort(final int n, final String string, final double d, TimeStamp timeStamp) {
        this.getSynthesizer().scheduleCommand(timeStamp, new ScheduledCommand(){

            public void run() {
                VoiceTracker voiceTracker = VoiceAllocator.this.findVoice(n);
                if (voiceTracker != null) {
                    voiceTracker.voice.setPort(string, d, VoiceAllocator.this.getSynthesizer().createTimeStamp());
                }
            }
        });
    }

    public void usePreset(final int n, TimeStamp timeStamp) {
        this.getSynthesizer().scheduleCommand(timeStamp, new ScheduledCommand(){

            public void run() {
                for (VoiceTracker voiceTracker : VoiceAllocator.this.trackers) {
                    voiceTracker.voice.usePreset(n);
                }
            }
        });
    }

    private class VoiceTracker {
        UnitVoice voice;
        int tag = -1;
        int presetIndex = -1;
        long when;
        boolean on;

        private VoiceTracker() {
        }

        public void off() {
            this.on = false;
            this.when = VoiceAllocator.this.tick++;
        }
    }
}

