/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.util;

import com.jsyn.ports.UnitInputPort;
import com.jsyn.ports.UnitOutputPort;
import com.jsyn.ports.UnitPort;
import com.jsyn.unitgen.Circuit;
import com.jsyn.unitgen.Multiply;
import com.jsyn.unitgen.PassThrough;
import com.jsyn.unitgen.UnitGenerator;
import com.jsyn.unitgen.UnitSource;
import com.jsyn.unitgen.UnitVoice;
import com.jsyn.util.Instrument;
import com.jsyn.util.VoiceAllocator;
import com.softsynth.shared.time.TimeStamp;

public class PolyphonicInstrument
extends Circuit
implements UnitSource,
Instrument {
    private Multiply mixer;
    private UnitVoice[] voices;
    private VoiceAllocator voiceAllocator;
    public UnitInputPort amplitude;

    public PolyphonicInstrument(UnitVoice[] unitVoiceArray) {
        this.voices = unitVoiceArray;
        this.voiceAllocator = new VoiceAllocator(unitVoiceArray);
        this.mixer = new Multiply();
        this.add(this.mixer);
        for (UnitVoice unitVoice : unitVoiceArray) {
            UnitGenerator unitGenerator = unitVoice.getUnitGenerator();
            boolean bl = unitGenerator.isEnabled();
            this.add(unitGenerator);
            unitVoice.getOutput().connect(this.mixer.inputA);
            unitGenerator.setEnabled(bl);
        }
        this.amplitude = this.mixer.inputB;
        this.addPort(this.amplitude, "Amplitude");
        this.amplitude.setup(1.0E-4, 0.4, 2.0);
    }

    public void exportAllInputPorts() {
        for (UnitPort unitPort : this.voices[0].getUnitGenerator().getPorts()) {
            UnitInputPort unitInputPort;
            String string;
            if (!(unitPort instanceof UnitInputPort) || (string = (unitInputPort = (UnitInputPort)unitPort).getName()).equals("Frequency") || string.equals("Amplitude")) continue;
            this.exportNamedInputPort(string);
        }
    }

    public void exportNamedInputPort(String string) {
        UnitInputPort unitInputPort = null;
        PassThrough passThrough = new PassThrough();
        for (UnitVoice unitVoice : this.voices) {
            unitInputPort = (UnitInputPort)unitVoice.getUnitGenerator().getPortByName(string);
            passThrough.output.connect(unitInputPort);
        }
        if (unitInputPort != null) {
            this.addPort(passThrough.input, string);
            passThrough.input.setup(unitInputPort);
        }
    }

    public UnitOutputPort getOutput() {
        return this.mixer.output;
    }

    public void usePreset(int n) {
        this.usePreset(n, this.getSynthesisEngine().createTimeStamp());
    }

    public void usePreset(int n, TimeStamp timeStamp) {
        for (UnitVoice object : this.voices) {
            object.usePreset(n);
        }
        for (UnitPort unitPort : this.voices[0].getUnitGenerator().getPorts()) {
            UnitInputPort unitInputPort;
            UnitInputPort unitInputPort2;
            if (!(unitPort instanceof UnitInputPort) || (unitInputPort2 = (UnitInputPort)this.getPortByName((unitInputPort = (UnitInputPort)unitPort).getName())) == null || unitInputPort2 == this.amplitude) continue;
            unitInputPort2.set(unitInputPort.get());
        }
    }

    public void noteOn(int n, double d, double d2, TimeStamp timeStamp) {
        this.voiceAllocator.noteOn(n, d, d2, timeStamp);
    }

    public void noteOff(int n, TimeStamp timeStamp) {
        this.voiceAllocator.noteOff(n, timeStamp);
    }

    public void setPort(int n, String string, double d, TimeStamp timeStamp) {
        this.voiceAllocator.setPort(n, string, d, timeStamp);
    }

    public void allNotesOff(TimeStamp timeStamp) {
        this.voiceAllocator.allNotesOff(timeStamp);
    }

    public synchronized boolean isOn(int n) {
        return this.voiceAllocator.isOn(n);
    }
}

