/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.util;

import com.jsyn.data.FloatSample;
import com.jsyn.util.AudioSampleLoader;
import com.jsyn.util.SampleLoader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;

class JavaSoundSampleLoader
implements AudioSampleLoader {
    JavaSoundSampleLoader() {
    }

    public FloatSample loadFloatSample(File file) throws IOException {
        try {
            return this.loadFloatSample(AudioSystem.getAudioInputStream(file));
        }
        catch (UnsupportedAudioFileException unsupportedAudioFileException) {
            throw new IOException(unsupportedAudioFileException);
        }
    }

    public FloatSample loadFloatSample(InputStream inputStream) throws IOException {
        try {
            return this.loadFloatSample(AudioSystem.getAudioInputStream(inputStream));
        }
        catch (UnsupportedAudioFileException unsupportedAudioFileException) {
            throw new IOException(unsupportedAudioFileException);
        }
    }

    public FloatSample loadFloatSample(URL uRL) throws IOException {
        try {
            return this.loadFloatSample(AudioSystem.getAudioInputStream(uRL));
        }
        catch (UnsupportedAudioFileException unsupportedAudioFileException) {
            throw new IOException(unsupportedAudioFileException);
        }
    }

    private FloatSample loadFloatSample(AudioInputStream audioInputStream) throws IOException, UnsupportedAudioFileException {
        float[] fArray = null;
        FloatSample floatSample = null;
        int n = audioInputStream.getFormat().getFrameSize();
        if (n == -1) {
            n = 1;
        }
        AudioFormat audioFormat = audioInputStream.getFormat();
        System.out.println("Format = " + audioFormat);
        if (audioFormat.getEncoding() == AudioFormat.Encoding.PCM_SIGNED) {
            fArray = this.loadSignedPCM(audioInputStream);
        }
        floatSample = new FloatSample(fArray, audioFormat.getChannels());
        floatSample.setFrameRate(audioFormat.getFrameRate());
        return floatSample;
    }

    private float[] loadSignedPCM(AudioInputStream audioInputStream) throws IOException, UnsupportedAudioFileException {
        int n = 0;
        AudioFormat audioFormat = audioInputStream.getFormat();
        int n2 = (int)audioInputStream.getFrameLength();
        int n3 = audioFormat.getChannels() * n2;
        float[] fArray = new float[n3];
        int n4 = audioFormat.getFrameSize();
        int n5 = 1024 * n4;
        byte[] byArray = new byte[n5];
        int n6 = 0;
        int n7 = 0;
        while ((n6 = audioInputStream.read(byArray)) != -1) {
            int n8 = n6 % n4;
            if (n8 != 0) {
                throw new IOException("Read partial block of sample data!");
            }
            if (audioInputStream.getFormat().getSampleSizeInBits() == 16) {
                if (audioFormat.isBigEndian()) {
                    SampleLoader.decodeBigI16ToF32(byArray, 0, n6, fArray, n);
                } else {
                    SampleLoader.decodeLittleI16ToF32(byArray, 0, n6, fArray, n);
                }
            } else if (audioInputStream.getFormat().getSampleSizeInBits() == 24) {
                if (audioFormat.isBigEndian()) {
                    SampleLoader.decodeBigI24ToF32(byArray, 0, n6, fArray, n);
                } else {
                    SampleLoader.decodeLittleI24ToF32(byArray, 0, n6, fArray, n);
                }
            } else if (audioInputStream.getFormat().getSampleSizeInBits() == 32) {
                if (audioFormat.isBigEndian()) {
                    SampleLoader.decodeBigI32ToF32(byArray, 0, n6, fArray, n);
                } else {
                    SampleLoader.decodeLittleI32ToF32(byArray, 0, n6, fArray, n);
                }
            } else {
                throw new UnsupportedAudioFileException("Only 16, 24 or 32 bit PCM samples supported.");
            }
            n7 = n6 / n4;
            n += n7 * audioFormat.getChannels();
        }
        return fArray;
    }
}

