/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.util;

import com.jsyn.Synthesizer;
import com.jsyn.io.AudioFifo;
import com.jsyn.io.AudioInputStream;
import com.jsyn.ports.UnitInputPort;
import com.jsyn.unitgen.MonoStreamWriter;
import com.jsyn.unitgen.StereoStreamWriter;
import com.jsyn.unitgen.UnitStreamWriter;

public class AudioStreamReader
implements AudioInputStream {
    private UnitStreamWriter streamWriter;
    private AudioFifo fifo;

    public AudioStreamReader(Synthesizer synthesizer, int n) {
        if (n == 1) {
            this.streamWriter = new MonoStreamWriter();
        } else if (n == 2) {
            this.streamWriter = new StereoStreamWriter();
        } else {
            throw new IllegalArgumentException("Only 1 or 2 samplesPerFrame supported.");
        }
        synthesizer.add(this.streamWriter);
        this.fifo = new AudioFifo();
        this.fifo.setWriteWaitEnabled(!synthesizer.isRealTime());
        this.fifo.setReadWaitEnabled(true);
        this.fifo.allocate(32768);
        this.streamWriter.setOutputStream(this.fifo);
        this.streamWriter.start();
    }

    public UnitInputPort getInput() {
        return this.streamWriter.input;
    }

    public int available() {
        return this.fifo.available();
    }

    public void close() {
        this.fifo.close();
    }

    public double read() {
        return this.fifo.read();
    }

    public int read(double[] dArray) {
        return this.fifo.read(dArray);
    }

    public int read(double[] dArray, int n, int n2) {
        return this.fifo.read(dArray, n, n2);
    }
}

