/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.Synthesizer;
import com.jsyn.engine.SynthesisEngine;
import com.jsyn.ports.ConnectableInput;
import com.jsyn.ports.UnitInputPort;
import com.jsyn.ports.UnitOutputPort;
import com.jsyn.ports.UnitPort;
import com.jsyn.unitgen.Circuit;
import com.softsynth.shared.time.TimeStamp;
import java.io.PrintStream;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UnitGenerator {
    protected static final double VERY_SMALL_FLOAT = 1.0E-26;
    public static final double FALSE = 0.0;
    public static final double TRUE = 1.0;
    protected SynthesisEngine synthesisEngine;
    private LinkedHashMap<String, UnitPort> ports = new LinkedHashMap();
    private Circuit circuit;
    private long lastFrameCount;
    private boolean enabled = true;
    private static int nextId;
    private int id = nextId++;
    private int frameRate;
    private double framePeriod;
    static Logger logger;

    public int getId() {
        return this.id;
    }

    public int getFrameRate() {
        return this.synthesisEngine.getFrameRate();
    }

    public double getFramePeriod() {
        return this.synthesisEngine.getFramePeriod();
    }

    public void addPort(UnitPort unitPort) {
        unitPort.setUnitGenerator(this);
        this.ports.put(unitPort.getName().toLowerCase(), unitPort);
    }

    public void addPort(UnitPort unitPort, String string) {
        unitPort.setName(string);
        this.addPort(unitPort);
    }

    public UnitPort getPortByName(String string) {
        return this.ports.get(string.toLowerCase());
    }

    public Collection<UnitPort> getPorts() {
        return this.ports.values();
    }

    public abstract void generate(int var1, int var2);

    public void generate() {
        this.generate(0, 8);
    }

    public SynthesisEngine getSynthesisEngine() {
        return this.synthesisEngine;
    }

    public Synthesizer getSynthesizer() {
        return this.synthesisEngine;
    }

    public void setSynthesisEngine(SynthesisEngine synthesisEngine) {
        if (this.synthesisEngine != null && this.synthesisEngine != synthesisEngine) {
            throw new RuntimeException("Unit synthesisEngine already set.");
        }
        this.synthesisEngine = synthesisEngine;
    }

    public UnitGenerator getTopUnit() {
        UnitGenerator unitGenerator = this;
        while (unitGenerator.circuit != null) {
            unitGenerator = unitGenerator.circuit;
        }
        logger.fine("getTopUnit " + this + " => " + unitGenerator);
        return unitGenerator;
    }

    protected void autoStop() {
        this.synthesisEngine.autoStopUnit(this.getTopUnit());
    }

    public double convertHalfLifeToMultiplier(double d) {
        if (d < 2.0 * this.getFramePeriod()) {
            return 1.0;
        }
        return 1.0 - Math.pow(0.5, 1.0 / (d * (double)this.getSynthesisEngine().getFrameRate()));
    }

    protected double incrementWrapPhase(double d, double d2) {
        if ((d += d2) >= 1.0) {
            d -= 2.0;
        } else if (d < -1.0) {
            d += 2.0;
        }
        return d;
    }

    protected double convertTimeToRate(double d) {
        double d2 = this.synthesisEngine.getInverseNyquist();
        if (d < d2) {
            return 1.0;
        }
        return this.getFramePeriod() / d;
    }

    public void flattenOutputs() {
        for (UnitPort unitPort : this.ports.values()) {
            if (!(unitPort instanceof UnitOutputPort)) continue;
            ((UnitOutputPort)unitPort).flatten();
        }
    }

    public void setCircuit(Circuit circuit) {
        if (this.circuit != null && circuit != null) {
            throw new RuntimeException("Unit is already in a circuit.");
        }
        this.circuit = circuit;
    }

    public Circuit getCircuit() {
        return this.circuit;
    }

    public void pullData(long l, int n, int n2) {
        if (this.enabled && l > this.lastFrameCount) {
            this.lastFrameCount = l;
            for (UnitPort unitPort : this.ports.values()) {
                if (!(unitPort instanceof ConnectableInput)) continue;
                ((ConnectableInput)((Object)unitPort)).pullData(l, n, n2);
            }
            this.generate(n, n2);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
        if (!bl) {
            this.flattenOutputs();
        }
    }

    public void start() {
        if (this.getSynthesisEngine() == null) {
            throw new RuntimeException("This " + this.getClass().getName() + " was not add()ed to a Synthesizer.");
        }
        this.getSynthesisEngine().startUnit(this);
    }

    public void start(double d) {
        this.start(new TimeStamp(d));
    }

    public void start(TimeStamp timeStamp) {
        if (this.getSynthesisEngine() == null) {
            throw new RuntimeException("This " + this.getClass().getName() + " was not add()ed to a Synthesizer.");
        }
        this.getSynthesisEngine().startUnit(this, timeStamp);
    }

    public void stop(double d) {
        this.stop(new TimeStamp(d));
    }

    public void stop() {
        this.getSynthesisEngine().stopUnit(this);
    }

    public void stop(TimeStamp timeStamp) {
        this.getSynthesisEngine().stopUnit(this, timeStamp);
    }

    public void setFrameRate(int n) {
        this.frameRate = n;
        this.framePeriod = 1.0 / (double)n;
    }

    public UnitGenerator getUnitGenerator() {
        return this;
    }

    public void setPort(String string, double d, TimeStamp timeStamp) {
        UnitInputPort unitInputPort = (UnitInputPort)this.getPortByName(string);
        if (unitInputPort == null) {
            logger.warning("port was null for name " + string + ", " + this.getClass().getName());
        } else {
            unitInputPort.set(d, timeStamp);
        }
    }

    public void printConnections() {
        this.printConnections(System.out);
    }

    public void printConnections(PrintStream printStream) {
        this.printConnections(printStream, 0);
    }

    public void printConnections(PrintStream printStream, int n) {
        for (UnitPort unitPort : this.getPorts()) {
            if (!(unitPort instanceof UnitInputPort)) continue;
            ((UnitInputPort)unitPort).printConnections(printStream, n);
        }
    }

    static {
        logger = Logger.getLogger(UnitGenerator.class.getName());
    }
}

