/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.data.Spectrum;
import com.jsyn.ports.UnitSpectralInputPort;
import com.jsyn.ports.UnitSpectralOutputPort;
import com.jsyn.unitgen.UnitGenerator;

public abstract class SpectralProcessor
extends UnitGenerator {
    public UnitSpectralInputPort input;
    public UnitSpectralOutputPort output;
    private int counter;

    public SpectralProcessor() {
        this.output = new UnitSpectralOutputPort();
        this.addPort(this.output);
        this.input = new UnitSpectralInputPort();
        this.addPort(this.input);
    }

    public SpectralProcessor(int n) {
        this.output = new UnitSpectralOutputPort(n);
        this.addPort(this.output);
        this.input = new UnitSpectralInputPort();
        this.addPort(this.input);
    }

    public void generate(int n, int n2) {
        for (int i = n; i < n2; ++i) {
            if (this.counter == 0) {
                if (!this.input.isAvailable()) continue;
                Spectrum spectrum = this.input.getSpectrum();
                Spectrum spectrum2 = this.output.getSpectrum();
                this.processSpectrum(spectrum, spectrum2);
                this.output.advance();
                this.counter = spectrum.size() - 1;
                continue;
            }
            --this.counter;
        }
    }

    public abstract void processSpectrum(Spectrum var1, Spectrum var2);
}

