/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.data.SpectralWindow;
import com.jsyn.data.Spectrum;
import com.jsyn.ports.UnitOutputPort;
import com.jsyn.ports.UnitSpectralInputPort;
import com.jsyn.unitgen.RectangularWindow;
import com.jsyn.unitgen.UnitGenerator;
import com.softsynth.math.FourierMath;

public class SpectralIFFT
extends UnitGenerator {
    public UnitSpectralInputPort input;
    public UnitOutputPort output;
    private Spectrum localSpectrum;
    private double[] buffer;
    private int cursor;
    private SpectralWindow window = RectangularWindow.getInstance();

    public SpectralIFFT() {
        this.output = new UnitOutputPort();
        this.addPort(this.output);
        this.input = new UnitSpectralInputPort("Input");
        this.addPort(this.input);
    }

    public void generate(int n, int n2) {
        double[] dArray = this.output.getValues();
        if (this.buffer == null) {
            if (this.input.isAvailable()) {
                Spectrum spectrum = this.input.getSpectrum();
                int n3 = spectrum.size();
                this.localSpectrum = new Spectrum(n3);
                this.buffer = this.localSpectrum.getReal();
                this.cursor = 0;
            } else {
                for (int i = n; i < n2; ++i) {
                    dArray[i] = 0.0;
                }
            }
        }
        if (this.buffer != null) {
            for (int i = n; i < n2; ++i) {
                if (this.cursor == 0) {
                    Spectrum spectrum = this.input.getSpectrum();
                    spectrum.copyTo(this.localSpectrum);
                    FourierMath.ifft(this.buffer.length, this.localSpectrum.getReal(), this.localSpectrum.getImaginary());
                }
                dArray[i] = this.buffer[this.cursor] * this.window.get(this.cursor);
                ++this.cursor;
                if (this.cursor != this.buffer.length) continue;
                this.cursor = 0;
            }
        }
    }

    public SpectralWindow getWindow() {
        return this.window;
    }

    public void setWindow(SpectralWindow spectralWindow) {
        this.window = spectralWindow;
    }
}

