/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.data.FloatSample;
import com.jsyn.unitgen.GrainCommon;
import com.jsyn.unitgen.GrainSource;

public class SampleGrainSource
extends GrainCommon
implements GrainSource {
    private FloatSample sample;
    private double position;
    private double positionRange;
    private double phase;
    private double phaseIncrement;
    private int numFramesGuarded;
    private static final double MAX_PHASE = 0.9999999999;

    public double next() {
        this.phase += this.phaseIncrement;
        if (this.phase > 0.9999999999) {
            this.phase = 0.9999999999;
        }
        double d = this.phase * (double)this.numFramesGuarded;
        return this.sample.interpolate(d);
    }

    public void setRate(double d) {
        this.phaseIncrement = d * this.sample.getFrameRate() / (this.getFrameRate() * (double)this.numFramesGuarded);
    }

    public void setSample(FloatSample floatSample) {
        this.sample = floatSample;
        this.numFramesGuarded = floatSample.getNumFrames() - 1;
    }

    public void setPosition(double d) {
        this.position = d;
    }

    public void reset() {
        double d = this.position + this.positionRange * (Math.random() - 0.5);
        this.phase = d * 0.5 + 0.5;
        if (this.phase < 0.0) {
            this.phase = 0.0;
        } else if (this.phase > 0.9999999999) {
            this.phase = 0.9999999999;
        }
    }

    public void setPositionRange(double d) {
        this.positionRange = d;
    }
}

