/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.ports.UnitInputPort;
import com.jsyn.ports.UnitOutputPort;
import com.jsyn.unitgen.UnitGenerator;

public class PowerOfTwo
extends UnitGenerator {
    public UnitInputPort input = new UnitInputPort("Input");
    public UnitOutputPort output;
    private static double[] table = new double[1026];
    private static final int NUM_VALUES = 1024;
    private double lastInput = 0.0;
    private double lastOutput = 1.0;

    public PowerOfTwo() {
        this.addPort(this.input);
        this.input.setup(-8.0, 0.0, 8.0);
        this.output = new UnitOutputPort("Output");
        this.addPort(this.output);
    }

    public void generate(int n, int n2) {
        double[] dArray = this.input.getValues();
        double[] dArray2 = this.output.getValues();
        for (int i = n; i < n2; ++i) {
            double d = dArray[i];
            if (d == this.lastInput) {
                dArray2[i] = this.lastOutput;
                continue;
            }
            int n3 = (int)Math.floor(d);
            double d2 = d - (double)n3;
            double d3 = d2 * 1024.0;
            int n4 = (int)d3;
            double d4 = d3 - (double)n4;
            double d5 = table[n4] + d4 * (table[n4 + 1] - table[n4]);
            while (n3 > 0) {
                --n3;
                d5 *= 2.0;
            }
            while (n3 < 0) {
                ++n3;
                d5 *= 0.5;
            }
            dArray2[i] = d5;
            this.lastInput = d;
            this.lastOutput = d5;
        }
    }

    static {
        for (int i = 0; i < table.length; ++i) {
            double d;
            PowerOfTwo.table[i] = d = Math.pow(2.0, (double)i / 1024.0);
        }
    }
}

