/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.ports.UnitInputPort;
import com.jsyn.ports.UnitOutputPort;
import com.jsyn.unitgen.UnitGenerator;
import com.jsyn.util.AutoCorrelator;
import com.jsyn.util.SignalCorrelator;

public class PitchDetector
extends UnitGenerator {
    public UnitInputPort input;
    public UnitOutputPort period;
    public UnitOutputPort confidence;
    public UnitOutputPort frequency;
    public UnitOutputPort updated;
    protected SignalCorrelator signalCorrelator;
    private double lastFrequency = 440.0;
    private double lastPeriod = 44100.0 / this.lastFrequency;
    private double lastConfidence = 0.0;
    private static final int LOWEST_FREQUENCY = 40;
    private static final int HIGHEST_RATE = 48000;
    private static final int CYCLES_NEEDED = 2;

    public PitchDetector() {
        this.input = new UnitInputPort("Input");
        this.addPort(this.input);
        this.period = new UnitOutputPort("Period");
        this.addPort(this.period);
        this.confidence = new UnitOutputPort("Confidence");
        this.addPort(this.confidence);
        this.frequency = new UnitOutputPort("Frequency");
        this.addPort(this.frequency);
        this.updated = new UnitOutputPort("Updated");
        this.addPort(this.updated);
        this.signalCorrelator = this.createSignalCorrelator();
    }

    public SignalCorrelator createSignalCorrelator() {
        int n = 2400;
        return new AutoCorrelator(n);
    }

    public void generate(int n, int n2) {
        double[] dArray = this.input.getValues();
        double[] dArray2 = this.period.getValues();
        double[] dArray3 = this.confidence.getValues();
        double[] dArray4 = this.frequency.getValues();
        double[] dArray5 = this.updated.getValues();
        for (int i = n; i < n2; ++i) {
            double d = dArray[i];
            if (this.signalCorrelator.addSample(d)) {
                this.lastPeriod = this.signalCorrelator.getPeriod();
                if (this.lastPeriod < 0.1) {
                    System.out.println("ILLEGAL PERIOD");
                }
                double d2 = (double)this.getFrameRate() / (this.lastPeriod + 0.0);
                double d3 = this.signalCorrelator.getConfidence();
                if (d3 > 0.1) {
                    double d4 = d3 * 0.2;
                    this.lastFrequency = this.lastFrequency * (1.0 - d4) + d2 * d4;
                }
                this.lastConfidence = d3;
                dArray5[i] = 1.0;
            } else {
                dArray5[i] = 0.0;
            }
            dArray2[i] = this.lastPeriod;
            dArray3[i] = this.lastConfidence;
            dArray4[i] = this.lastFrequency;
        }
    }

    public float[] getDiffs() {
        return this.signalCorrelator.getDiffs();
    }
}

