/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.ports.UnitInputPort;
import com.jsyn.ports.UnitOutputPort;
import com.jsyn.unitgen.UnitGenerator;
import com.jsyn.unitgen.UnitSource;
import com.jsyn.util.PseudoRandom;

public class PinkNoise
extends UnitGenerator
implements UnitSource {
    public UnitInputPort amplitude;
    public UnitOutputPort output;
    private final int NUM_ROWS = 16;
    private final int RANDOM_BITS = 24;
    private final int RANDOM_SHIFT = 8;
    private PseudoRandom randomNum;
    protected double prevNoise;
    protected double currNoise;
    private long[] rows = new long[16];
    private double scalar;
    private int runningSum;
    private int index;
    private int indexMask;

    public PinkNoise() {
        this.amplitude = new UnitInputPort("Amplitude", 0.999969482421875);
        this.addPort(this.amplitude);
        this.output = new UnitOutputPort("Output");
        this.addPort(this.output);
        this.randomNum = new PseudoRandom();
        this.index = 0;
        this.indexMask = 65535;
        int n = 0x8800000;
        this.scalar = 1.0 / (double)n;
        for (int i = 0; i < 16; ++i) {
            this.rows[i] = 0L;
        }
        this.runningSum = 0;
    }

    public void generate(int n, int n2) {
        double[] dArray = this.amplitude.getValues();
        double[] dArray2 = this.output.getValues();
        for (int i = n; i < n2; ++i) {
            dArray2[i] = this.generatePinkNoise() * dArray[i];
        }
    }

    public double generatePinkNoise() {
        int n;
        int n2;
        this.index = this.index + 1 & this.indexMask;
        if (this.index != 0) {
            n2 = 0;
            n = this.index;
            while ((n & 1) == 0) {
                n >>= 1;
                ++n2;
            }
            this.runningSum = (int)((long)this.runningSum - this.rows[n2]);
            int n3 = this.randomNum.nextRandomInteger() >> 8;
            this.runningSum += n3;
            this.rows[n2] = n3;
        }
        n2 = this.randomNum.nextRandomInteger() >> 8;
        n = this.runningSum + n2;
        return this.scalar * (double)n;
    }

    public UnitOutputPort getOutput() {
        return this.output;
    }
}

