/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.ports.UnitInputPort;
import com.jsyn.unitgen.UnitFilter;

public class PhaseShifter
extends UnitFilter {
    public UnitInputPort offset = new UnitInputPort("Offset", 0.1);
    public UnitInputPort feedback;
    public UnitInputPort depth;
    private double zm1;
    private double[] xs;
    private double[] ys;

    public PhaseShifter() {
        this(6);
    }

    public PhaseShifter(int n) {
        this.addPort(this.offset);
        this.feedback = new UnitInputPort("Feedback", 0.7);
        this.addPort(this.feedback);
        this.depth = new UnitInputPort("Depth", 1.0);
        this.addPort(this.depth);
        this.xs = new double[n];
        this.ys = new double[n];
    }

    public void generate(int n, int n2) {
        double[] dArray = this.input.getValues();
        double[] dArray2 = this.output.getValues();
        double[] dArray3 = this.feedback.getValues();
        double[] dArray4 = this.depth.getValues();
        double[] dArray5 = this.offset.getValues();
        for (int i = n; i < n2; ++i) {
            double d = dArray5[i];
            double d2 = 1.0 - d * d;
            if (d2 < -1.0) {
                d2 = -1.0;
            }
            double d3 = dArray[i] + this.zm1 * dArray3[i];
            for (int j = 0; j < this.xs.length; ++j) {
                double d4 = this.ys[j] = d2 * (this.ys[j] - d3) + this.xs[j];
                this.xs[j] = d3;
                d3 = d4;
            }
            this.zm1 = d3;
            dArray2[i] = dArray[i] + d3 * dArray4[i];
        }
    }
}

