/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.ports.UnitInputPort;
import com.jsyn.ports.UnitOutputPort;
import com.jsyn.unitgen.UnitGenerator;

public class ParabolicEnvelope
extends UnitGenerator {
    public UnitInputPort frequency;
    public UnitInputPort triggerInput = new UnitInputPort("Input");
    public UnitInputPort amplitude;
    public UnitOutputPort triggerOutput;
    public UnitOutputPort triggerPass;
    public UnitOutputPort output;
    private double slope;
    private double curve;
    private double level;
    private boolean running;

    public ParabolicEnvelope() {
        this.addPort(this.triggerInput);
        this.frequency = new UnitInputPort("Frequency", 440.0);
        this.addPort(this.frequency);
        this.amplitude = new UnitInputPort("Amplitude", 0.999969482421875);
        this.addPort(this.amplitude);
        this.output = new UnitOutputPort("Output");
        this.addPort(this.output);
        this.triggerOutput = new UnitOutputPort("TriggerOutput");
        this.addPort(this.triggerOutput);
        this.triggerPass = new UnitOutputPort("TriggerPass");
        this.addPort(this.triggerPass);
    }

    public void generate(int n, int n2) {
        double[] dArray = this.frequency.getValues();
        double[] dArray2 = this.amplitude.getValues();
        double[] dArray3 = this.triggerInput.getValues();
        double[] dArray4 = this.output.getValues();
        double[] dArray5 = this.triggerPass.getValues();
        double[] dArray6 = this.triggerOutput.getValues();
        for (int i = n; i < n2; ++i) {
            if (!this.running) {
                if (dArray3[i] > 0.0) {
                    double d = dArray[i] * this.synthesisEngine.getInverseNyquist();
                    d = d > 1.0 ? 1.0 : (d < -1.0 ? -1.0 : d);
                    double d2 = dArray2[i];
                    double d3 = d * d;
                    this.slope = 4.0 * d2 * (d - d3);
                    this.curve = -8.0 * d2 * d3;
                    this.level = 0.0;
                    dArray6[i] = 1.0;
                    this.running = true;
                } else {
                    dArray6[i] = 0.0;
                }
                dArray5[i] = 0.0;
            } else {
                this.level += this.slope;
                this.slope += this.curve;
                if (this.level <= 0.0) {
                    this.level = 0.0;
                    this.running = false;
                }
                dArray6[i] = 0.0;
                dArray5[i] = dArray3[i];
            }
            dArray4[i] = this.level;
        }
    }
}

