/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.ports.UnitInputPort;
import com.jsyn.unitgen.MixerMono;
import com.jsyn.unitgen.SineOscillator;

public class MixerStereo
extends MixerMono {
    public UnitInputPort pan;
    protected PanTracker[] panTrackers;

    public MixerStereo(int n) {
        super(n);
        this.pan = new UnitInputPort(n, "Pan");
        this.addPort(this.pan);
        this.pan.setup(-1.0, 0.0, 1.0);
        this.panTrackers = new PanTracker[n];
        for (int i = 0; i < n; ++i) {
            this.panTrackers[i] = new PanTracker();
        }
    }

    public int getNumOutputs() {
        return 2;
    }

    public void generate(int n, int n2) {
        double[] dArray = this.amplitude.getValues(0);
        double[] dArray2 = this.output.getValues(0);
        double[] dArray3 = this.output.getValues(1);
        for (int i = n; i < n2; ++i) {
            double d = 0.0;
            double d2 = 0.0;
            for (int j = 0; j < this.input.getNumParts(); ++j) {
                double[] dArray4 = this.input.getValues(j);
                double[] dArray5 = this.gain.getValues(j);
                double[] dArray6 = this.pan.getValues(j);
                PanTracker panTracker = this.panTrackers[j];
                panTracker.update(dArray6[i]);
                double d3 = dArray4[i] * dArray5[i];
                d += d3 * panTracker.leftGain;
                d2 += d3 * panTracker.rightGain;
            }
            double d4 = dArray[i];
            dArray2[i] = d * d4;
            dArray3[i] = d2 * d4;
        }
    }

    static class PanTracker {
        double previousPan = Double.MAX_VALUE;
        double leftGain;
        double rightGain;

        PanTracker() {
        }

        public void update(double d) {
            if (d != this.previousPan) {
                double d2 = d * 0.25 + 0.25;
                this.leftGain = SineOscillator.fastSin(0.5 - d2);
                this.rightGain = SineOscillator.fastSin(d2);
                this.previousPan = d;
            }
        }
    }
}

