/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.ports.UnitInputPort;
import com.jsyn.ports.UnitOutputPort;
import com.jsyn.unitgen.UnitGenerator;
import com.jsyn.unitgen.UnitSink;
import com.jsyn.unitgen.UnitSource;

public class MixerMono
extends UnitGenerator
implements UnitSink,
UnitSource {
    public UnitInputPort input;
    public UnitInputPort gain;
    public UnitInputPort amplitude;
    public UnitOutputPort output;

    public MixerMono(int n) {
        this.input = new UnitInputPort(n, "Input");
        this.addPort(this.input);
        this.gain = new UnitInputPort(n, "Gain", 1.0);
        this.addPort(this.gain);
        this.amplitude = new UnitInputPort("Amplitude", 1.0);
        this.addPort(this.amplitude);
        this.output = new UnitOutputPort(this.getNumOutputs(), "Output");
        this.addPort(this.output);
    }

    public int getNumOutputs() {
        return 1;
    }

    public void generate(int n, int n2) {
        double[] dArray = this.amplitude.getValues(0);
        double[] dArray2 = this.output.getValues(0);
        for (int i = n; i < n2; ++i) {
            double d = 0.0;
            for (int j = 0; j < this.input.getNumParts(); ++j) {
                double[] dArray3 = this.input.getValues(j);
                double[] dArray4 = this.gain.getValues(j);
                d += dArray3[i] * dArray4[i];
            }
            dArray2[i] = d * dArray[i];
        }
    }

    public UnitInputPort getInput() {
        return this.input;
    }

    public UnitOutputPort getOutput() {
        return this.output;
    }
}

