/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.ports.UnitInputPort;
import com.jsyn.ports.UnitVariablePort;
import com.jsyn.unitgen.UnitFilter;

public class LinearRamp
extends UnitFilter {
    public UnitInputPort time = new UnitInputPort("Time");
    public UnitVariablePort current;
    private double source;
    private double phase;
    private double target;
    private double timeHeld = 0.0;
    private double rate = 1.0;

    public LinearRamp() {
        this.addPort(this.time);
        this.current = new UnitVariablePort("Current");
        this.addPort(this.current);
    }

    public void generate(int n, int n2) {
        double[] dArray = this.output.getValues();
        double d = this.input.getValues()[0];
        double d2 = this.time.getValues()[0];
        double d3 = this.current.getValue();
        if (d2 != this.timeHeld) {
            this.rate = this.convertTimeToRate(d2);
            this.timeHeld = d2;
        }
        if (d != this.target) {
            this.source = d3;
            this.phase = 0.0;
            this.target = d;
        }
        for (int i = n; i < n2; ++i) {
            if (this.phase < 1.0) {
                d3 = this.source + this.phase * (this.target - this.source);
                this.phase += this.rate;
            } else {
                d3 = this.target;
            }
            dArray[i] = d3;
        }
        this.current.setValue(d3);
    }
}

