/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.ports.UnitInputPort;
import com.jsyn.ports.UnitOutputPort;
import com.jsyn.unitgen.Grain;
import com.jsyn.unitgen.GrainScheduler;
import com.jsyn.unitgen.GrainSourceSine;
import com.jsyn.unitgen.RaisedCosineEnvelope;
import com.jsyn.unitgen.StochasticGrainScheduler;
import com.jsyn.unitgen.UnitGenerator;
import com.jsyn.unitgen.UnitSource;
import com.jsyn.util.PseudoRandom;

public class GrainFarm
extends UnitGenerator
implements UnitSource {
    public UnitInputPort rate;
    public UnitInputPort rateRange;
    public UnitInputPort amplitude;
    public UnitInputPort amplitudeRange;
    public UnitInputPort density;
    public UnitInputPort duration;
    public UnitInputPort durationRange;
    public UnitOutputPort output;
    PseudoRandom randomizer;
    private GrainState[] states;
    private double countScaler = 1.0;
    private GrainScheduler scheduler = new StochasticGrainScheduler();

    public GrainFarm() {
        this.randomizer = new PseudoRandom();
        this.rate = new UnitInputPort("Rate", 1.0);
        this.addPort(this.rate);
        this.amplitude = new UnitInputPort("Amplitude", 1.0);
        this.addPort(this.amplitude);
        this.duration = new UnitInputPort("Duration", 0.01);
        this.addPort(this.duration);
        this.rateRange = new UnitInputPort("RateRange", 0.0);
        this.addPort(this.rateRange);
        this.amplitudeRange = new UnitInputPort("AmplitudeRange", 0.0);
        this.addPort(this.amplitudeRange);
        this.durationRange = new UnitInputPort("DurationRange", 0.0);
        this.addPort(this.durationRange);
        this.density = new UnitInputPort("Density", 0.1);
        this.addPort(this.density);
        this.output = new UnitOutputPort();
        this.addPort(this.output);
    }

    public void setGrainArray(Grain[] grainArray) {
        this.countScaler = 1.0 / (double)grainArray.length;
        this.states = new GrainState[grainArray.length];
        for (int i = 0; i < this.states.length; ++i) {
            this.states[i] = new GrainState();
            this.states[i].grain = grainArray[i];
            grainArray[i].setFrameRate(this.getSynthesisEngine().getFrameRate());
        }
    }

    public void setupGrain(Grain grain, int n) {
        double d = this.rate.getValues()[n] * this.calculateOctaveScaler(this.rateRange.getValues()[n]);
        grain.setRate(d);
        double d2 = this.amplitude.getValues()[n];
        double d3 = d2 * Math.random() * this.amplitudeRange.getValues()[n];
        grain.setAmplitude(d2 - d3);
    }

    public void allocate(int n) {
        Grain[] grainArray = new Grain[n];
        for (int i = 0; i < n; ++i) {
            Grain grain;
            grainArray[i] = grain = new Grain(new GrainSourceSine(), new RaisedCosineEnvelope());
        }
        this.setGrainArray(grainArray);
    }

    public UnitOutputPort getOutput() {
        return this.output;
    }

    private double calculateOctaveScaler(double d) {
        double d2 = 0.5 * this.randomizer.nextRandomDouble() * d;
        return Math.pow(2.0, d2);
    }

    public void generate(int n, int n2) {
        double[] dArray = this.output.getValues();
        double[] dArray2 = this.amplitude.getValues();
        for (int i = n; i < n2; ++i) {
            double d = 0.0;
            for (GrainState grainState : this.states) {
                d += grainState.next(i);
            }
            dArray[i] = d * dArray2[i] * this.countScaler;
        }
    }

    private class GrainState {
        Grain grain;
        int countdown;
        double lastDuration;
        static final int STATE_IDLE = 0;
        static final int STATE_GAP = 1;
        static final int STATE_RUNNING = 2;
        int state = 0;
        private double gapError;

        private GrainState() {
        }

        public double next(int n) {
            double d = 0.0;
            if (this.state == 2) {
                if (this.grain.hasMoreValues()) {
                    d = this.grain.next();
                } else {
                    this.startGap(n);
                }
            } else if (this.state == 1) {
                if (this.countdown > 0) {
                    --this.countdown;
                } else if (this.countdown == 0) {
                    this.state = 2;
                    this.grain.reset();
                    GrainFarm.this.setupGrain(this.grain, n);
                    double d2 = this.nextDuration(n);
                    this.grain.setDuration(d2);
                }
            } else if (this.state == 0) {
                this.nextDuration(n);
                this.startGap(n);
            }
            return d;
        }

        private double nextDuration(int n) {
            double d = GrainFarm.this.duration.getValues()[n];
            this.lastDuration = d = GrainFarm.this.scheduler.nextDuration(d);
            return d;
        }

        private void startGap(int n) {
            this.state = 1;
            double d = GrainFarm.this.density.getValues()[n];
            double d2 = GrainFarm.this.scheduler.nextGap(this.lastDuration, d) * (double)GrainFarm.this.getFrameRate();
            this.countdown = (int)(d2 += this.gapError);
            this.gapError = d2 - (double)this.countdown;
        }
    }
}

