/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.ports.UnitInputPort;
import com.jsyn.ports.UnitOutputPort;
import com.jsyn.unitgen.TunableFilter;

public class FilterStateVariable
extends TunableFilter {
    public UnitInputPort amplitude;
    public UnitInputPort resonance;
    public UnitOutputPort lowPass;
    public UnitOutputPort bandPass;
    public UnitOutputPort highPass;
    private double freqInternal;
    private double previousFrequency = Double.MAX_VALUE;
    private double lowPassValue;
    private double bandPassValue;

    public FilterStateVariable() {
        this.frequency.set(440.0);
        this.resonance = new UnitInputPort("Resonance", 0.2);
        this.addPort(this.resonance);
        this.amplitude = new UnitInputPort("Amplitude", 1.0);
        this.addPort(this.amplitude);
        this.lowPass = new UnitOutputPort("LowPass");
        this.addPort(this.lowPass);
        this.bandPass = new UnitOutputPort("BandPass");
        this.addPort(this.bandPass);
        this.highPass = new UnitOutputPort("HighPass");
        this.addPort(this.highPass);
    }

    public void generate(int n, int n2) {
        double[] dArray = this.input.getValues();
        double[] dArray2 = this.output.getValues();
        double[] dArray3 = this.frequency.getValues();
        double[] dArray4 = this.amplitude.getValues();
        double[] dArray5 = this.resonance.getValues();
        double[] dArray6 = this.lowPass.getValues();
        double[] dArray7 = this.highPass.getValues();
        double[] dArray8 = this.bandPass.getValues();
        double d = dArray3[0];
        if (d != this.previousFrequency) {
            this.previousFrequency = d;
            this.freqInternal = 2.0 * Math.sin(Math.PI * d * this.getFramePeriod());
        }
        for (int i = n; i < n2; ++i) {
            double d2;
            this.lowPassValue = this.freqInternal * this.bandPassValue + this.lowPassValue;
            dArray6[i] = this.lowPassValue = this.lowPassValue < -1.0 ? -1.0 : (this.lowPassValue > 1.0 ? 1.0 : this.lowPassValue);
            dArray2[i] = this.lowPassValue * dArray4[i];
            dArray7[i] = d2 = dArray[i] - dArray5[i] * this.bandPassValue - this.lowPassValue;
            dArray8[i] = this.bandPassValue = this.freqInternal * d2 + this.bandPassValue;
        }
    }
}

