/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.ports.UnitInputPort;
import com.jsyn.unitgen.FilterBiquadCommon;

public class FilterPeakingEQ
extends FilterBiquadCommon {
    public UnitInputPort gain = new UnitInputPort("Gain", 1.0);
    private double previousGain;

    public FilterPeakingEQ() {
        this.addPort(this.gain);
    }

    protected boolean isRecalculationNeeded(double d, double d2) {
        double d3 = this.gain.getValues()[0];
        if (d3 < 1.0E-5) {
            d3 = 1.0E-5;
        }
        boolean bl = super.isRecalculationNeeded(d, d2);
        boolean bl2 = this.previousGain != d3;
        this.previousGain = d3;
        return bl |= bl2;
    }

    public void updateCoefficients() {
        double d = Math.sqrt(this.previousGain);
        double d2 = this.alpha * d;
        double d3 = this.alpha / d;
        double d4 = 1.0 / (1.0 + d3);
        double d5 = -2.0 * this.cos_omega * d4;
        this.a0 = (1.0 + d2) * d4;
        this.a1 = d5;
        this.a2 = (1.0 - d2) * d4;
        this.b1 = d5;
        this.b2 = (1.0 - d3) * d4;
    }
}

