/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.ports.UnitInputPort;
import com.jsyn.unitgen.TunableFilter;

public class FilterFourPoles
extends TunableFilter {
    public UnitInputPort Q = new UnitInputPort("Q");
    public UnitInputPort gain;
    private static final double MINIMUM_FREQUENCY = 1.0E-5;
    private static final double MINIMUM_Q = 1.0E-5;
    private double x1;
    private double x2;
    private double x3;
    private double x4;
    private double y1;
    private double y2;
    private double y3;
    private double y4;
    private double previousFrequency;
    private double previousQ;
    private double f;
    private double fTo4th;
    private double feedback;
    private boolean oversampled = true;

    public FilterFourPoles() {
        this.addPort(this.Q);
        this.Q.setup(0.1, 2.0, 10.0);
    }

    public void recalculate() {
        double d = this.frequency.getValues()[0];
        double d2 = this.Q.getValues()[0];
        if (d < 1.0E-5) {
            d = 1.0E-5;
        }
        if (d2 < 1.0E-5) {
            d2 = 1.0E-5;
        }
        if (d != this.previousFrequency || d2 != this.previousQ) {
            this.previousFrequency = d;
            this.previousQ = d2;
            this.computeCoefficients();
        }
    }

    private void computeCoefficients() {
        double d = this.previousFrequency * this.getFramePeriod();
        double d2 = 4.9 - 0.27 * this.previousQ;
        if (d2 < 3.0) {
            d2 = 3.0;
        }
        this.f = d * (this.oversampled ? 1.0 : 2.0) * d2;
        double d3 = this.f * this.f;
        this.fTo4th = d3 * d3;
        this.feedback = 0.5 * this.previousQ * (1.0 - 0.15 * d3);
    }

    public void generate(int n, int n2) {
        double[] dArray = this.input.getValues();
        double[] dArray2 = this.output.getValues();
        this.recalculate();
        for (int i = n; i < n2; ++i) {
            double d = dArray[i];
            if (this.oversampled) {
                this.oneSample(0.0);
            }
            this.oneSample(d);
            dArray2[i] = this.y4;
        }
        this.y1 += 1.0E-26;
        this.y2 -= 1.0E-26;
    }

    private void oneSample(double d) {
        d -= this.y4 * this.feedback;
        this.y1 = (d *= 0.35013 * this.fTo4th) + 0.3 * this.x1 + (1.0 - this.f) * this.y1;
        this.x1 = d;
        this.y2 = this.y1 + 0.3 * this.x2 + (1.0 - this.f) * this.y2;
        this.x2 = this.y1;
        this.y3 = this.y2 + 0.3 * this.x3 + (1.0 - this.f) * this.y3;
        this.x3 = this.y2;
        this.y4 = this.y3 + 0.3 * this.x4 + (1.0 - this.f) * this.y4;
        this.y4 = this.clip(this.y4);
        this.x4 = this.y3;
    }

    public boolean isOversampled() {
        return this.oversampled;
    }

    public void setOversampled(boolean bl) {
        this.oversampled = bl;
    }

    private double clip(double d) {
        return d - d * d * d * 0.1666667;
    }
}

