/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.ports.UnitInputPort;
import com.jsyn.ports.UnitOutputPort;
import com.jsyn.unitgen.Circuit;
import com.jsyn.unitgen.UnitGate;
import com.jsyn.unitgen.UnitSource;

public class EnvelopeDAHDSR
extends UnitGate
implements UnitSource {
    private static final double MIN_DURATION = 1.0E-5;
    public UnitInputPort delay;
    public UnitInputPort attack;
    public UnitInputPort hold;
    public UnitInputPort decay;
    public UnitInputPort sustain;
    public UnitInputPort release;
    public UnitInputPort amplitude;
    private State state = State.IDLE;
    private double countdown;
    private double scaler = 1.0;
    private double level;
    private double increment;

    public EnvelopeDAHDSR() {
        this.delay = new UnitInputPort("Delay", 0.0);
        this.addPort(this.delay);
        this.delay.setup(0.0, 0.0, 2.0);
        this.attack = new UnitInputPort("Attack", 0.1);
        this.addPort(this.attack);
        this.attack.setup(0.01, 0.1, 8.0);
        this.hold = new UnitInputPort("Hold", 0.0);
        this.addPort(this.hold);
        this.hold.setup(0.0, 0.0, 2.0);
        this.decay = new UnitInputPort("Decay", 0.2);
        this.addPort(this.decay);
        this.decay.setup(0.01, 0.2, 8.0);
        this.sustain = new UnitInputPort("Sustain", 0.5);
        this.addPort(this.sustain);
        this.sustain.setup(0.0, 0.5, 1.0);
        this.release = new UnitInputPort("Release", 0.3);
        this.addPort(this.release);
        this.release.setup(0.01, 0.3, 8.0);
        this.amplitude = new UnitInputPort("Amplitude", 1.0);
        this.addPort(this.amplitude);
    }

    public void generate(int n, int n2) {
        double[] dArray = this.sustain.getValues();
        double[] dArray2 = this.amplitude.getValues();
        double[] dArray3 = this.output.getValues();
        int n3 = n;
        while (n3 < n2) {
            boolean bl = this.input.checkGate(n3);
            block0 : switch (this.state) {
                case IDLE: {
                    while (n3 < n2) {
                        dArray3[n3] = this.level * dArray2[n3];
                        if (bl) {
                            this.startDelay(n3);
                            break block0;
                        }
                        ++n3;
                    }
                    break;
                }
                case DELAYING: {
                    while (n3 < n2) {
                        dArray3[n3] = this.level * dArray2[n3];
                        if (this.input.isOff()) {
                            this.startRelease(n3);
                            break block0;
                        }
                        this.countdown -= 1.0;
                        if (this.countdown <= 0.0) {
                            this.startAttack(n3);
                            break block0;
                        }
                        ++n3;
                    }
                    break;
                }
                case ATTACKING: {
                    while (n3 < n2) {
                        this.level += this.increment;
                        if (this.level >= 1.0) {
                            this.level = 1.0;
                            dArray3[n3] = this.level * dArray2[n3];
                            this.startHold(n3);
                            break block0;
                        }
                        dArray3[n3] = this.level * dArray2[n3];
                        if (this.input.isOff()) {
                            this.startRelease(n3);
                            break block0;
                        }
                        ++n3;
                    }
                    break;
                }
                case HOLDING: {
                    while (n3 < n2) {
                        dArray3[n3] = dArray2[n3];
                        this.countdown -= 1.0;
                        if (this.countdown <= 0.0) {
                            this.startDecay(n3);
                            break block0;
                        }
                        if (this.input.isOff()) {
                            this.startRelease(n3);
                            break block0;
                        }
                        ++n3;
                    }
                    break;
                }
                case DECAYING: {
                    while (n3 < n2) {
                        dArray3[n3] = this.level * dArray2[n3];
                        this.level *= this.scaler;
                        if (bl) {
                            this.startDelay(n3);
                            break block0;
                        }
                        if (this.level < dArray[n3]) {
                            this.level = dArray[n3];
                            this.startSustain(n3);
                            break block0;
                        }
                        if (this.level < 1.5848931924611107E-5) {
                            this.input.checkAutoDisable();
                            this.startIdle();
                            break block0;
                        }
                        if (this.input.isOff()) {
                            this.startRelease(n3);
                            break block0;
                        }
                        ++n3;
                    }
                    break;
                }
                case SUSTAINING: {
                    while (n3 < n2) {
                        this.level = dArray[n3];
                        dArray3[n3] = this.level * dArray2[n3];
                        if (bl) {
                            this.startDelay(n3);
                            break block0;
                        }
                        if (this.input.isOff()) {
                            this.startRelease(n3);
                            break block0;
                        }
                        ++n3;
                    }
                    break;
                }
                case RELEASING: {
                    while (n3 < n2) {
                        dArray3[n3] = this.level * dArray2[n3];
                        this.level *= this.scaler;
                        if (bl) {
                            this.startDelay(n3);
                            break block0;
                        }
                        if (this.level < 1.5848931924611107E-5) {
                            this.input.checkAutoDisable();
                            this.startIdle();
                            break block0;
                        }
                        ++n3;
                    }
                    break;
                }
            }
        }
    }

    private void startIdle() {
        this.state = State.IDLE;
        this.level = 0.0;
    }

    private void startDelay(int n) {
        double[] dArray = this.delay.getValues();
        if (dArray[n] <= 0.0) {
            this.startAttack(n);
        } else {
            this.countdown = (int)(dArray[n] * (double)this.getFrameRate());
            this.state = State.DELAYING;
        }
    }

    private void startAttack(int n) {
        double[] dArray = this.attack.getValues();
        double d = dArray[n];
        if (d < 1.0E-5) {
            this.level = 1.0;
            this.startHold(n);
        } else {
            this.increment = this.getFramePeriod() / d;
            this.state = State.ATTACKING;
        }
    }

    private void startHold(int n) {
        double[] dArray = this.hold.getValues();
        if (dArray[n] <= 0.0) {
            this.startDecay(n);
        } else {
            this.countdown = (int)(dArray[n] * (double)this.getFrameRate());
            this.state = State.HOLDING;
        }
    }

    private void startDecay(int n) {
        double[] dArray = this.decay.getValues();
        double d = dArray[n];
        if (d < 1.0E-5) {
            this.startSustain(n);
        } else {
            this.scaler = this.getSynthesisEngine().convertTimeToExponentialScaler(d);
            this.state = State.DECAYING;
        }
    }

    private void startSustain(int n) {
        this.state = State.SUSTAINING;
    }

    private void startRelease(int n) {
        double[] dArray = this.release.getValues();
        double d = dArray[n];
        if (d < 1.0E-5) {
            d = 1.0E-5;
        }
        this.scaler = this.getSynthesisEngine().convertTimeToExponentialScaler(d);
        this.state = State.RELEASING;
    }

    public void export(Circuit circuit, String string) {
        circuit.addPort(this.attack, string + this.attack.getName());
        circuit.addPort(this.decay, string + this.decay.getName());
        circuit.addPort(this.sustain, string + this.sustain.getName());
        circuit.addPort(this.release, string + this.release.getName());
    }

    public UnitOutputPort getOutput() {
        return this.output;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        IDLE,
        DELAYING,
        ATTACKING,
        HOLDING,
        DECAYING,
        SUSTAINING,
        RELEASING;

    }
}

