/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.ports.UnitInputPort;
import com.jsyn.unitgen.Circuit;
import com.jsyn.unitgen.UnitGate;

public class EnvelopeAttackDecay
extends UnitGate {
    public static final double THRESHOLD = 0.01;
    private static final double MIN_DURATION = 1.0E-5;
    public UnitInputPort attack;
    public UnitInputPort decay;
    public UnitInputPort amplitude;
    private State state = State.IDLE;
    private double scaler = 1.0;
    private double level;
    private double increment;

    public EnvelopeAttackDecay() {
        this.attack = new UnitInputPort("Attack");
        this.addPort(this.attack);
        this.attack.setup(0.001, 0.05, 8.0);
        this.decay = new UnitInputPort("Decay");
        this.addPort(this.decay);
        this.decay.setup(0.001, 0.2, 8.0);
        this.amplitude = new UnitInputPort("Amplitude", 1.0);
        this.addPort(this.amplitude);
        this.startIdle();
    }

    public void export(Circuit circuit, String string) {
        circuit.addPort(this.attack, string + this.attack.getName());
        circuit.addPort(this.decay, string + this.decay.getName());
    }

    public void generate(int n, int n2) {
        double[] dArray = this.amplitude.getValues();
        double[] dArray2 = this.output.getValues();
        int n3 = n;
        while (n3 < n2) {
            boolean bl = this.input.checkGate(n3);
            block0 : switch (this.state) {
                case IDLE: {
                    while (n3 < n2) {
                        dArray2[n3] = this.level;
                        if (bl) {
                            this.startAttack(n3);
                            break block0;
                        }
                        ++n3;
                    }
                    break;
                }
                case ATTACKING: {
                    while (n3 < n2) {
                        this.level += this.increment;
                        if (this.level >= 1.0) {
                            this.level = 1.0;
                            dArray2[n3] = this.level * dArray[n3];
                            this.startDecay(n3);
                            break block0;
                        }
                        dArray2[n3] = this.level * dArray[n3];
                        ++n3;
                    }
                    break;
                }
                case DECAYING: {
                    while (n3 < n2) {
                        dArray2[n3] = this.level * dArray[n3];
                        this.level *= this.scaler;
                        if (bl) {
                            this.startAttack(n3);
                            break block0;
                        }
                        if (this.level < 3.0517578125E-5) {
                            this.input.checkAutoDisable();
                            this.startIdle();
                            break block0;
                        }
                        ++n3;
                    }
                    break;
                }
            }
        }
    }

    private void startIdle() {
        this.state = State.IDLE;
        this.level = 0.0;
    }

    private void startAttack(int n) {
        double[] dArray = this.attack.getValues();
        double d = dArray[n];
        if (d < 1.0E-5) {
            this.level = 1.0;
            this.startDecay(n);
        } else {
            this.increment = this.getFramePeriod() / d;
            this.state = State.ATTACKING;
        }
    }

    private void startDecay(int n) {
        double[] dArray = this.decay.getValues();
        double d = dArray[n];
        if (d < 1.0E-5) {
            this.startIdle();
        } else {
            this.scaler = this.getSynthesisEngine().convertTimeToExponentialScaler(d);
            this.state = State.DECAYING;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        IDLE,
        ATTACKING,
        DECAYING;

    }
}

