/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.swing;

import com.jsyn.Synthesizer;
import com.jsyn.ports.UnitInputPort;
import com.jsyn.ports.UnitPort;
import com.jsyn.swing.ASCIIMusicKeyboard;
import com.jsyn.swing.DoubleBoundedRangeSlider;
import com.jsyn.swing.PortControllerFactory;
import com.jsyn.unitgen.UnitGenerator;
import com.jsyn.unitgen.UnitSource;
import com.jsyn.unitgen.UnitVoice;
import com.jsyn.util.Instrument;
import com.softsynth.jsyn.EqualTemperedTuning;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SoundTweaker
extends JPanel {
    private UnitSource source;
    private ASCIIMusicKeyboard keyboard;
    private Synthesizer synth;
    static Logger logger = Logger.getLogger(SoundTweaker.class.getName());

    public SoundTweaker(Synthesizer synthesizer, String string, UnitSource unitSource) {
        this.synth = synthesizer;
        this.source = unitSource;
        this.setLayout(new GridLayout(0, 1));
        UnitGenerator unitGenerator = unitSource.getUnitGenerator();
        ArrayList<DoubleBoundedRangeSlider> arrayList = new ArrayList<DoubleBoundedRangeSlider>();
        this.add(new JLabel(string));
        if (unitSource instanceof Instrument) {
            this.keyboard = this.createPolyphonicKeyboard();
            this.add(this.keyboard);
        } else if (unitSource instanceof UnitVoice) {
            this.keyboard = this.createMonophonicKeyboard();
            this.add(this.keyboard);
        }
        for (UnitPort object : unitGenerator.getPorts()) {
            if (!(object instanceof UnitInputPort)) continue;
            UnitInputPort unitInputPort = (UnitInputPort)object;
            DoubleBoundedRangeSlider doubleBoundedRangeSlider = unitInputPort.getMinimum() > 0.0 && unitInputPort.getMaximum() / unitInputPort.getMinimum() > 4.0 ? PortControllerFactory.createExponentialPortSlider(unitInputPort) : PortControllerFactory.createPortSlider(unitInputPort);
            this.add(doubleBoundedRangeSlider);
            arrayList.add(doubleBoundedRangeSlider);
        }
        if (this.keyboard != null) {
            for (Component component : arrayList) {
                component.addKeyListener(this.keyboard.getKeyListener());
            }
        }
        this.validate();
    }

    private ASCIIMusicKeyboard createPolyphonicKeyboard() {
        ASCIIMusicKeyboard aSCIIMusicKeyboard = new ASCIIMusicKeyboard(){

            public void keyOff(int n) {
                logger.info("-------------- keyOff " + n);
                ((Instrument)((Object)SoundTweaker.this.source)).noteOff(n, SoundTweaker.this.synth.createTimeStamp());
            }

            public void keyOn(int n) {
                logger.info("-------------- keyOn " + n);
                double d = EqualTemperedTuning.getMIDIFrequency(n);
                ((Instrument)((Object)SoundTweaker.this.source)).noteOn(n, d, 0.5, SoundTweaker.this.synth.createTimeStamp());
            }
        };
        return aSCIIMusicKeyboard;
    }

    private ASCIIMusicKeyboard createMonophonicKeyboard() {
        ASCIIMusicKeyboard aSCIIMusicKeyboard = new ASCIIMusicKeyboard(){

            public void keyOff(int n) {
                ((UnitVoice)SoundTweaker.this.source).noteOff(SoundTweaker.this.synth.createTimeStamp());
            }

            public void keyOn(int n) {
                double d = EqualTemperedTuning.getMIDIFrequency(n);
                ((UnitVoice)SoundTweaker.this.source).noteOn(d, 0.5, SoundTweaker.this.synth.createTimeStamp());
            }
        };
        return aSCIIMusicKeyboard;
    }
}

