/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.swing;

import com.jsyn.ports.UnitInputPort;
import com.jsyn.swing.DoubleBoundedRangeModel;
import com.jsyn.swing.DoubleBoundedRangeSlider;
import com.jsyn.swing.ExponentialRangeModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PortControllerFactory {
    private static final int RESOLUTION = 100000;

    public static DoubleBoundedRangeSlider createPortSlider(final UnitInputPort unitInputPort) {
        DoubleBoundedRangeModel doubleBoundedRangeModel = new DoubleBoundedRangeModel(unitInputPort.getName(), 100000, unitInputPort.getMinimum(), unitInputPort.getMaximum(), unitInputPort.get());
        doubleBoundedRangeModel.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                DoubleBoundedRangeModel doubleBoundedRangeModel = (DoubleBoundedRangeModel)changeEvent.getSource();
                double d = doubleBoundedRangeModel.getDoubleValue();
                unitInputPort.set(d);
            }
        });
        return new DoubleBoundedRangeSlider(doubleBoundedRangeModel, 3);
    }

    public static DoubleBoundedRangeSlider createExponentialPortSlider(final UnitInputPort unitInputPort) {
        ExponentialRangeModel exponentialRangeModel = new ExponentialRangeModel(unitInputPort.getName(), 100000, unitInputPort.getMinimum(), unitInputPort.getMaximum(), unitInputPort.get());
        exponentialRangeModel.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ExponentialRangeModel exponentialRangeModel = (ExponentialRangeModel)changeEvent.getSource();
                double d = exponentialRangeModel.getDoubleValue();
                unitInputPort.set(d);
            }
        });
        return new DoubleBoundedRangeSlider(exponentialRangeModel, 3);
    }
}

