/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.swing;

import com.jsyn.swing.PresetSelectionListener;
import com.jsyn.util.InstrumentLibrary;
import com.jsyn.util.VoiceDescription;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.ArrayList;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class InstrumentBrowser
extends JPanel {
    private InstrumentLibrary library;
    private JList instrumentList;
    private JScrollPane listScroller2;
    private VoiceDescription voiceDescription;
    private ArrayList<PresetSelectionListener> listeners = new ArrayList();

    public InstrumentBrowser(InstrumentLibrary instrumentLibrary) {
        this.library = instrumentLibrary;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 2));
        this.instrumentList = this.createList(instrumentLibrary.getVoiceDescriptions());
        this.instrumentList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n;
                if (!listSelectionEvent.getValueIsAdjusting() && (n = InstrumentBrowser.this.instrumentList.getSelectedIndex()) >= 0) {
                    InstrumentBrowser.this.showPresetList(n);
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.instrumentList);
        jScrollPane.setPreferredSize(new Dimension(250, 120));
        this.add(jScrollPane);
        this.showPresetList(0);
    }

    public void addPresetSelectionListener(PresetSelectionListener presetSelectionListener) {
        this.listeners.add(presetSelectionListener);
    }

    public void removePresetSelectionListener(PresetSelectionListener presetSelectionListener) {
        this.listeners.remove(presetSelectionListener);
    }

    private void firePresetSelectionListeners(VoiceDescription voiceDescription, int n) {
        for (PresetSelectionListener presetSelectionListener : this.listeners) {
            presetSelectionListener.presetSelected(voiceDescription, n);
        }
    }

    private void showPresetList(int n) {
        if (this.listScroller2 != null) {
            this.remove(this.listScroller2);
        }
        this.voiceDescription = this.library.getVoiceDescriptions()[n];
        final JList jList = this.createList(this.voiceDescription.getPresetNames());
        jList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n;
                if (!listSelectionEvent.getValueIsAdjusting() && (n = jList.getSelectedIndex()) >= 0) {
                    InstrumentBrowser.this.firePresetSelectionListeners(InstrumentBrowser.this.voiceDescription, n);
                }
            }
        });
        this.listScroller2 = new JScrollPane(jList);
        this.listScroller2.setPreferredSize(new Dimension(250, 120));
        this.add(this.listScroller2);
        jList.setSelectedIndex(0);
        this.validate();
    }

    private JList createList(Object[] objectArray) {
        JList<Object> jList = new JList<Object>(objectArray);
        jList.setSelectionMode(1);
        jList.setLayoutOrientation(0);
        jList.setVisibleRowCount(-1);
        return jList;
    }
}

