/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.swing;

import com.jsyn.swing.DoubleBoundedRangeModel;
import com.jsyn.swing.DoubleBoundedTextField;
import com.jsyn.swing.EnvelopeEditorBox;
import com.jsyn.swing.EnvelopePoints;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class EnvelopeEditorPanel
extends JPanel {
    EnvelopeEditorBox editor;
    Checkbox pointsBox;
    Checkbox sustainBox;
    Checkbox releaseBox;
    Checkbox autoBox;
    Button onButton;
    Button offButton;
    Button clearButton;
    Button yUpButton;
    Button yDownButton;
    DoubleBoundedTextField zoomField;

    public EnvelopeEditorPanel(EnvelopePoints envelopePoints, int n) {
        this.setSize(600, 300);
        this.setLayout(new BorderLayout());
        this.editor = new EnvelopeEditorBox();
        this.editor.setMaxPoints(n);
        this.editor.setBackground(Color.cyan);
        this.editor.setPoints(envelopePoints);
        this.editor.setMinimumSize(new Dimension(500, 300));
        this.add((Component)this.editor, "Center");
        JPanel jPanel = new JPanel();
        this.add((Component)jPanel, "South");
        CheckboxGroup checkboxGroup = new CheckboxGroup();
        this.pointsBox = new Checkbox("points", checkboxGroup, true);
        this.pointsBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                EnvelopeEditorPanel.this.editor.setMode(0);
            }
        });
        jPanel.add(this.pointsBox);
        this.sustainBox = new Checkbox("onLoop", checkboxGroup, false);
        this.sustainBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                EnvelopeEditorPanel.this.editor.setMode(1);
            }
        });
        jPanel.add(this.sustainBox);
        this.releaseBox = new Checkbox("offLoop", checkboxGroup, false);
        this.releaseBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                EnvelopeEditorPanel.this.editor.setMode(2);
            }
        });
        jPanel.add(this.releaseBox);
        this.autoBox = new Checkbox("AutoStop", false);
        this.yUpButton = new Button("Y*2");
        jPanel.add(this.yUpButton);
        this.yUpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EnvelopeEditorPanel.this.scaleEnvelopeValues(2.0);
            }
        });
        this.yDownButton = new Button("Y/2");
        jPanel.add(this.yDownButton);
        this.yDownButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EnvelopeEditorPanel.this.scaleEnvelopeValues(0.5);
            }
        });
        double d = this.getMaxEnvelopeValue(this.editor.getPoints());
        this.editor.setMaxWorldY(d);
        jPanel.add(new Label("YMax ="));
        final DoubleBoundedRangeModel doubleBoundedRangeModel = new DoubleBoundedRangeModel("YMax", 100000, 1.0, 100001.0, 1.0);
        this.zoomField = new DoubleBoundedTextField(doubleBoundedRangeModel, 8);
        jPanel.add(this.zoomField);
        doubleBoundedRangeModel.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                try {
                    double d = doubleBoundedRangeModel.getDoubleValue();
                    EnvelopeEditorPanel.this.editor.setMaxWorldY(d);
                    EnvelopeEditorPanel.this.editor.repaint();
                }
                catch (NumberFormatException numberFormatException) {
                    EnvelopeEditorPanel.this.zoomField.setText("ERROR");
                    EnvelopeEditorPanel.this.zoomField.selectAll();
                }
            }
        });
        this.validate();
    }

    double getMaxEnvelopeValue(EnvelopePoints envelopePoints) {
        double d = 1.0;
        for (int i = 0; i < envelopePoints.size(); ++i) {
            double d2 = envelopePoints.getValue(i);
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    void scaleEnvelopeValues(double d) {
        EnvelopePoints envelopePoints = this.editor.getPoints();
        for (int i = 0; i < envelopePoints.size(); ++i) {
            double[] dArray = envelopePoints.getPoint(i);
            dArray[1] = dArray[1] * d;
        }
        envelopePoints.setDirty(true);
        this.editor.repaint();
    }
}

