/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.swing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.HashSet;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public abstract class ASCIIMusicKeyboard
extends JPanel {
    private JCheckBox sustainBox;
    private JButton focusButton;
    public static final String PENTATONIC_KEYS = "zxcvbasdfgqwert12345";
    public static final String SEPTATONIC_KEYS = "zxcvbnmasdfghjqwertyu1234567890";
    private String keyboardLayout = "zxcvbnmasdfghjqwertyu1234567890";
    private int basePitch = 48;
    private KeyListener keyListener;
    private JLabel countLabel;
    private int onCount;
    private int offCount;
    private int pressedCount;
    private int releasedCount;
    private HashSet<Integer> pressedKeys = new HashSet();
    private HashSet<Integer> onKeys = new HashSet();

    public ASCIIMusicKeyboard() {
        this.focusButton = new JButton("Click here to play ASCII keys.");
        this.focusButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
            }
        });
        this.keyListener = new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
                char c = keyEvent.getKeyChar();
                int n = ASCIIMusicKeyboard.this.keyboardLayout.indexOf(c);
                System.out.println("keyPressed " + n);
                if (n >= 0 && !ASCIIMusicKeyboard.this.pressedKeys.contains(n)) {
                    ASCIIMusicKeyboard.this.keyOn(ASCIIMusicKeyboard.this.convertIndexToPitch(n));
                    ASCIIMusicKeyboard.this.onCount++;
                    ASCIIMusicKeyboard.this.pressedKeys.add(n);
                    ASCIIMusicKeyboard.this.onKeys.add(n);
                }
                ASCIIMusicKeyboard.this.pressedCount++;
                ASCIIMusicKeyboard.this.updateCountLabel();
            }

            public void keyReleased(KeyEvent keyEvent) {
                char c = keyEvent.getKeyChar();
                int n = ASCIIMusicKeyboard.this.keyboardLayout.indexOf(c);
                System.out.println("keyReleased " + n);
                if (n >= 0) {
                    if (!ASCIIMusicKeyboard.this.sustainBox.isSelected()) {
                        ASCIIMusicKeyboard.this.noteOffInternal(n);
                        ASCIIMusicKeyboard.this.onKeys.remove(n);
                    }
                    ASCIIMusicKeyboard.this.pressedKeys.remove(n);
                }
                ASCIIMusicKeyboard.this.releasedCount++;
                ASCIIMusicKeyboard.this.updateCountLabel();
            }

            public void keyTyped(KeyEvent keyEvent) {
            }
        };
        this.focusButton.addKeyListener(this.keyListener);
        this.add(this.focusButton);
        this.sustainBox = new JCheckBox("sustain");
        this.sustainBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!ASCIIMusicKeyboard.this.sustainBox.isSelected()) {
                    for (Integer n : ASCIIMusicKeyboard.this.onKeys) {
                        ASCIIMusicKeyboard.this.noteOffInternal(n);
                    }
                    ASCIIMusicKeyboard.this.onKeys.clear();
                }
            }
        });
        this.add(this.sustainBox);
        this.sustainBox.addKeyListener(this.keyListener);
        this.countLabel = new JLabel("0");
        this.add(this.countLabel);
    }

    private void noteOffInternal(int n) {
        this.keyOff(this.convertIndexToPitch(n));
        ++this.offCount;
    }

    protected void updateCountLabel() {
        this.countLabel.setText(this.onCount + "/" + this.offCount + ", " + this.pressedCount + "/" + this.releasedCount);
    }

    public int convertIndexToPitch(int n) {
        int[] nArray = new int[]{0, 2, 4, 5, 7, 9, 11};
        int n2 = n / nArray.length;
        int n3 = n % nArray.length;
        int n4 = n2 * 12 + nArray[n3];
        return n4 + this.basePitch;
    }

    public abstract void keyOff(int var1);

    public abstract void keyOn(int var1);

    public String getKeyboardLayout() {
        return this.keyboardLayout;
    }

    public void setKeyboardLayout(String string) {
        this.keyboardLayout = string;
    }

    public int getBasePitch() {
        return this.basePitch;
    }

    public void setBasePitch(int n) {
        this.basePitch = n;
    }

    public KeyListener getKeyListener() {
        return this.keyListener;
    }
}

