/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.scope.swing;

import com.jsyn.scope.AudioScopeModel;
import com.jsyn.scope.AudioScopeProbe;
import com.jsyn.scope.swing.AudioScopeProbeView;
import com.jsyn.scope.swing.MultipleWaveDisplay;
import com.jsyn.scope.swing.ScopeControlPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AudioScopeView
extends JPanel {
    private static final long serialVersionUID = -7507986850757860853L;
    private AudioScopeModel audioScopeModel;
    private ArrayList<AudioScopeProbeView> probeViews = new ArrayList();
    private MultipleWaveDisplay multipleWaveDisplay;
    private boolean showControls = false;
    private ScopeControlPanel controlPanel = null;

    public AudioScopeView() {
        this.setBackground(Color.GREEN);
    }

    public void setModel(AudioScopeModel audioScopeModel) {
        this.audioScopeModel = audioScopeModel;
        this.probeViews.clear();
        for (AudioScopeProbe audioScopeProbe : audioScopeModel.getProbes()) {
            AudioScopeProbeView audioScopeProbeView = new AudioScopeProbeView(audioScopeProbe);
            this.probeViews.add(audioScopeProbeView);
        }
        this.setupGUI();
        audioScopeModel.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                AudioScopeView.this.multipleWaveDisplay.repaint();
            }
        });
    }

    private void setupGUI() {
        this.removeAll();
        this.setLayout(new BorderLayout());
        this.multipleWaveDisplay = new MultipleWaveDisplay();
        for (AudioScopeProbeView audioScopeProbeView : this.probeViews) {
            this.multipleWaveDisplay.addWaveTrace(audioScopeProbeView.getWaveTraceView());
            audioScopeProbeView.getModel().setColor(audioScopeProbeView.getWaveTraceView().getColor());
        }
        this.add((Component)this.multipleWaveDisplay, "Center");
        this.setMinimumSize(new Dimension(400, 200));
        this.setPreferredSize(new Dimension(600, 250));
        this.setMaximumSize(new Dimension(1200, 300));
    }

    public void setShowControls(boolean bl) {
        this.setControlsVisible(bl);
    }

    public void setControlsVisible(boolean bl) {
        if (this.showControls) {
            if (!bl && this.controlPanel != null) {
                this.remove(this.controlPanel);
            }
        } else if (bl) {
            if (this.controlPanel == null) {
                this.controlPanel = new ScopeControlPanel(this);
            }
            this.add((Component)this.controlPanel, "East");
            this.validate();
        }
        this.showControls = bl;
    }

    public AudioScopeModel getModel() {
        return this.audioScopeModel;
    }

    public AudioScopeProbeView[] getProbeViews() {
        return this.probeViews.toArray(new AudioScopeProbeView[0]);
    }
}

