/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.scope;

import com.jsyn.ports.UnitInputPort;
import com.jsyn.scope.AudioScope;
import com.jsyn.scope.TriggerModel;
import com.jsyn.unitgen.UnitGenerator;
import com.softsynth.shared.time.ScheduledCommand;

public class MultiChannelScopeProbeUnit
extends UnitGenerator {
    public UnitInputPort input;
    public UnitInputPort trigger;
    private static final int STATE_IDLE = 0;
    private static final int STATE_ARMED = 1;
    private static final int STATE_READY = 2;
    private static final int STATE_TRIGGERED = 3;
    private int state = 0;
    private int numChannels;
    private double[][] inputValues;
    private static final int FRAMES_PER_BUFFER = 4096;
    private static final int FRAMES_PER_BUFFER_MASK = 4095;
    private Runnable callback;
    private TriggerModel triggerModel;
    private int autoCountdown;
    private int countdown;
    private int postTriggerSize = 512;
    SignalBuffer captureBuffer;
    SignalBuffer displayBuffer;

    public MultiChannelScopeProbeUnit(int n, TriggerModel triggerModel) {
        this.numChannels = n;
        this.captureBuffer = new SignalBuffer(n);
        this.displayBuffer = new SignalBuffer(n);
        this.triggerModel = triggerModel;
        this.trigger = new UnitInputPort(n, "Trigger");
        this.addPort(this.trigger);
        this.input = new UnitInputPort(n, "Input");
        this.addPort(this.input);
        this.inputValues = new double[n][];
    }

    private synchronized void switchBuffers() {
        SignalBuffer signalBuffer = this.captureBuffer;
        this.captureBuffer = this.displayBuffer;
        this.displayBuffer = signalBuffer;
    }

    private void internalArm(Runnable runnable) {
        this.callback = runnable;
        this.state = 1;
        this.captureBuffer.reset();
    }

    public void arm(double d, Runnable runnable) {
        ScheduledArm scheduledArm = new ScheduledArm(runnable);
        this.getSynthesisEngine().scheduleCommand(d, (ScheduledCommand)scheduledArm);
    }

    public void generate(int n, int n2) {
        if (this.state != 0) {
            int n3;
            AudioScope.TriggerMode triggerMode = this.triggerModel.getMode();
            double d = this.triggerModel.getTriggerLevel();
            double[] dArray = this.trigger.getValues();
            for (n3 = 0; n3 < this.numChannels; ++n3) {
                this.inputValues[n3] = this.input.getValues(n3);
            }
            block6: for (n3 = n; n3 < n2; ++n3) {
                int n4;
                for (n4 = 0; n4 < this.numChannels; ++n4) {
                    this.captureBuffer.saveChannelValue(n4, (float)this.inputValues[n4][n3]);
                }
                this.captureBuffer.bumpCursor();
                switch (this.state) {
                    case 1: {
                        if (!(dArray[n3] <= d)) continue block6;
                        this.state = 2;
                        this.autoCountdown = 44100;
                        continue block6;
                    }
                    case 2: {
                        n4 = 0;
                        if (dArray[n3] > d) {
                            n4 = 1;
                        } else if (triggerMode.equals((Object)AudioScope.TriggerMode.AUTO) && --this.autoCountdown == 0) {
                            n4 = 1;
                        }
                        if (n4 == 0) continue block6;
                        this.captureBuffer.markTrigger();
                        this.state = 3;
                        this.countdown = this.postTriggerSize;
                        continue block6;
                    }
                    case 3: {
                        --this.countdown;
                        if (this.countdown > 0) continue block6;
                        this.state = 0;
                        this.switchBuffers();
                        this.fireCallback();
                    }
                }
            }
        }
    }

    private void fireCallback() {
        if (this.callback != null) {
            this.callback.run();
        }
    }

    public float getSample(int n, int n2) {
        return this.displayBuffer.getSample(n, n2);
    }

    public int getTriggerIndex() {
        return this.displayBuffer.getTriggerIndex();
    }

    public int getFramesCaptured() {
        return this.displayBuffer.getFramesCaptured();
    }

    public int getFramesPerBuffer() {
        return 4096;
    }

    public int getPostTriggerSize() {
        return this.postTriggerSize;
    }

    class ScheduledArm
    implements ScheduledCommand {
        private Runnable callback;

        ScheduledArm(Runnable runnable) {
            this.callback = runnable;
        }

        public void run() {
            MultiChannelScopeProbeUnit.this.internalArm(this.callback);
        }
    }

    class SignalBuffer {
        float[][] buffers;
        private int writeCursor;
        private int triggerIndex;
        private int framesCaptured;

        SignalBuffer(int n) {
            this.buffers = new float[n][];
            for (int i = 0; i < n; ++i) {
                this.buffers[i] = new float[4096];
            }
        }

        void reset() {
            this.writeCursor = 0;
            this.triggerIndex = 0;
            this.framesCaptured = 0;
        }

        public void saveChannelValue(int n, float f) {
            this.buffers[n][this.writeCursor] = f;
        }

        public void markTrigger() {
            this.triggerIndex = this.writeCursor;
        }

        public void bumpCursor() {
            this.writeCursor = this.writeCursor + 1 & 0xFFF;
            if (this.writeCursor >= 4096) {
                this.writeCursor = 0;
            }
            if (this.framesCaptured < 4096) {
                ++this.framesCaptured;
            }
        }

        private int convertInternalToExternalIndex(int n) {
            if (this.framesCaptured < 4096) {
                return n;
            }
            return n - this.writeCursor & 0xFFF;
        }

        private int convertExternalToInternalIndex(int n) {
            if (this.framesCaptured < 4096) {
                return n;
            }
            return n + this.writeCursor & 0xFFF;
        }

        public int getTriggerIndex() {
            return this.convertInternalToExternalIndex(this.triggerIndex);
        }

        public int getFramesCaptured() {
            return this.framesCaptured;
        }

        public float getSample(int n, int n2) {
            int n3 = this.convertExternalToInternalIndex(n2);
            return this.buffers[n][n3];
        }
    }
}

