/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.scope;

import com.jsyn.Synthesizer;
import com.jsyn.ports.UnitOutputPort;
import com.jsyn.scope.AudioScopeModel;
import com.jsyn.scope.AudioScopeProbe;
import com.jsyn.scope.swing.AudioScopeView;

public class AudioScope {
    private AudioScopeView audioScopeView = null;
    private AudioScopeModel audioScopeModel;

    public AudioScope(Synthesizer synthesizer) {
        this.audioScopeModel = new AudioScopeModel(synthesizer);
    }

    public AudioScopeProbe addProbe(UnitOutputPort unitOutputPort) {
        return this.addProbe(unitOutputPort, 0);
    }

    public AudioScopeProbe addProbe(UnitOutputPort unitOutputPort, int n) {
        return this.audioScopeModel.addProbe(unitOutputPort, n);
    }

    public void start() {
        this.audioScopeModel.start();
    }

    public void stop() {
        this.audioScopeModel.stop();
    }

    public AudioScopeModel getModel() {
        return this.audioScopeModel;
    }

    public AudioScopeView getView() {
        if (this.audioScopeView == null) {
            this.audioScopeView = new AudioScopeView();
            this.audioScopeView.setModel(this.audioScopeModel);
        }
        return this.audioScopeView;
    }

    public void setTriggerMode(TriggerMode triggerMode) {
        this.audioScopeModel.setTriggerMode(triggerMode);
    }

    public void setTriggerSource(AudioScopeProbe audioScopeProbe) {
        this.audioScopeModel.setTriggerSource(audioScopeProbe);
    }

    public void setTriggerLevel(double d) {
        this.getModel().getTriggerModel().getLevelModel().setDoubleValue(d);
    }

    public double getTriggerLevel() {
        return this.getModel().getTriggerModel().getLevelModel().getDoubleValue();
    }

    public void setViewMode(ViewMode viewMode) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ViewMode {
        WAVEFORM,
        SPECTRUM;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TriggerMode {
        AUTO,
        NORMAL;

    }
}

