/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.ports;

import com.jsyn.data.Spectrum;
import com.jsyn.ports.ConnectableInput;
import com.jsyn.ports.ConnectableOutput;
import com.jsyn.ports.PortBlockPart;
import com.jsyn.ports.UnitPort;
import com.jsyn.ports.UnitSpectralOutputPort;

public class UnitSpectralInputPort
extends UnitPort
implements ConnectableInput {
    private UnitSpectralOutputPort other;
    private Spectrum spectrum;

    public UnitSpectralInputPort() {
        this("Output");
    }

    public UnitSpectralInputPort(String string) {
        super(string);
    }

    public void setSpectrum(Spectrum spectrum) {
        this.spectrum = spectrum;
    }

    public Spectrum getSpectrum() {
        if (this.other == null) {
            return this.spectrum;
        }
        return this.other.getSpectrum();
    }

    public void connect(ConnectableOutput connectableOutput) {
        if (!(connectableOutput instanceof UnitSpectralOutputPort)) {
            throw new RuntimeException("Can only connect UnitSpectralOutputPort to UnitSpectralInputPort!");
        }
        this.other = (UnitSpectralOutputPort)connectableOutput;
    }

    public void disconnect(ConnectableOutput connectableOutput) {
        if (this.other == connectableOutput) {
            this.other = null;
        }
    }

    public PortBlockPart getPortBlockPart() {
        return null;
    }

    public void pullData(long l, int n, int n2) {
        if (this.other != null) {
            this.other.getUnitGenerator().pullData(l, n, n2);
        }
    }

    public boolean isAvailable() {
        if (this.other != null) {
            return this.other.isAvailable();
        }
        return this.spectrum != null;
    }
}

