/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.ports;

import com.jsyn.engine.SynthesisEngine;
import com.jsyn.ports.ConnectableInput;
import com.jsyn.ports.ConnectableOutput;
import com.jsyn.ports.UnitBlockPort;
import com.softsynth.shared.time.ScheduledCommand;
import com.softsynth.shared.time.TimeStamp;
import java.util.ArrayList;

public class PortBlockPart
implements ConnectableOutput,
ConnectableInput {
    private double[] values = new double[8];
    private ArrayList<PortBlockPart> connections = new ArrayList();
    private UnitBlockPort unitBlockPort;

    protected PortBlockPart(UnitBlockPort unitBlockPort, double d) {
        this.unitBlockPort = unitBlockPort;
        this.setValue(d);
    }

    public double[] getValues() {
        return this.values;
    }

    public double getValue() {
        return this.values[0];
    }

    public double get() {
        return this.values[0];
    }

    protected void setValue(double d) {
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = d;
        }
    }

    protected boolean isConnected() {
        return this.connections.size() > 0;
    }

    private void addConnection(PortBlockPart portBlockPart) {
        if (this.connections.contains(portBlockPart)) {
            System.out.println("addConnection alreacy had connection from " + this + " to " + portBlockPart);
        } else {
            this.connections.add(portBlockPart);
        }
    }

    private void removeConnection(PortBlockPart portBlockPart) {
        this.connections.remove(portBlockPart);
    }

    private void connectNow(PortBlockPart portBlockPart) {
        this.addConnection(portBlockPart);
        portBlockPart.addConnection(this);
    }

    private void disconnectNow(PortBlockPart portBlockPart) {
        this.removeConnection(portBlockPart);
        portBlockPart.removeConnection(this);
    }

    private void disconnectAllNow() {
        for (PortBlockPart portBlockPart : this.connections) {
            portBlockPart.removeConnection(this);
        }
        this.connections.clear();
    }

    public PortBlockPart getConnection(int n) {
        return this.connections.get(n);
    }

    public int getConnectionCount() {
        return this.connections.size();
    }

    protected void flatten() {
        double d = this.values[this.values.length - 1];
        for (int i = 0; i < this.values.length - 1; ++i) {
            this.values[i] = d;
        }
    }

    protected UnitBlockPort getPort() {
        return this.unitBlockPort;
    }

    private void checkConnection(PortBlockPart portBlockPart) {
        SynthesisEngine synthesisEngine;
        SynthesisEngine synthesisEngine2 = this.unitBlockPort.getSynthesisEngine();
        if (synthesisEngine2 != (synthesisEngine = portBlockPart.unitBlockPort.getSynthesisEngine()) && synthesisEngine2 != null && synthesisEngine != null) {
            throw new RuntimeException("Connection between units on different synths.");
        }
    }

    protected void connect(final PortBlockPart portBlockPart) {
        this.checkConnection(portBlockPart);
        this.unitBlockPort.queueCommand(new ScheduledCommand(){

            public void run() {
                PortBlockPart.this.connectNow(portBlockPart);
            }
        });
    }

    protected void connect(final PortBlockPart portBlockPart, TimeStamp timeStamp) {
        this.unitBlockPort.scheduleCommand(timeStamp, new ScheduledCommand(){

            public void run() {
                PortBlockPart.this.connectNow(portBlockPart);
            }
        });
    }

    protected void disconnect(final PortBlockPart portBlockPart) {
        this.unitBlockPort.queueCommand(new ScheduledCommand(){

            public void run() {
                PortBlockPart.this.disconnectNow(portBlockPart);
            }
        });
    }

    protected void disconnect(final PortBlockPart portBlockPart, TimeStamp timeStamp) {
        this.unitBlockPort.scheduleCommand(timeStamp, new ScheduledCommand(){

            public void run() {
                PortBlockPart.this.disconnectNow(portBlockPart);
            }
        });
    }

    protected void disconnectAll() {
        this.unitBlockPort.queueCommand(new ScheduledCommand(){

            public void run() {
                PortBlockPart.this.disconnectAllNow();
            }
        });
    }

    public void connect(ConnectableInput connectableInput) {
        this.connect(connectableInput.getPortBlockPart());
    }

    public void connect(ConnectableOutput connectableOutput) {
        connectableOutput.connect(this);
    }

    public void disconnect(ConnectableOutput connectableOutput) {
        connectableOutput.disconnect(this);
    }

    public void disconnect(ConnectableInput connectableInput) {
        this.disconnect(connectableInput.getPortBlockPart());
    }

    public PortBlockPart getPortBlockPart() {
        return this;
    }

    public void pullData(long l, int n, int n2) {
        for (int i = 0; i < this.getConnectionCount(); ++i) {
            PortBlockPart portBlockPart = this.getConnection(i);
            portBlockPart.getPort().getUnitGenerator().pullData(l, n, n2);
        }
    }
}

