/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.ports;

import com.jsyn.ports.PortBlockPart;
import com.jsyn.ports.UnitBlockPort;
import com.jsyn.unitgen.UnitGenerator;
import java.io.PrintStream;

public class InputMixingBlockPart
extends PortBlockPart {
    private double[] mixer = new double[8];
    private double current;

    InputMixingBlockPart(UnitBlockPort unitBlockPort, double d) {
        super(unitBlockPort, d);
    }

    public double getValue() {
        return this.current;
    }

    protected void setValue(double d) {
        this.current = d;
        super.setValue(d);
    }

    public double[] getValues() {
        double[] dArray;
        int n = this.getConnectionCount();
        if (n == 0) {
            dArray = super.getValues();
        } else if (n == 1) {
            PortBlockPart portBlockPart = this.getConnection(0);
            dArray = portBlockPart.getValues();
        } else {
            int n2;
            PortBlockPart portBlockPart = this.getConnection(0);
            double[] dArray2 = portBlockPart.getValues();
            for (n2 = 0; n2 < this.mixer.length; ++n2) {
                this.mixer[n2] = dArray2[n2];
            }
            for (n2 = 1; n2 < n; ++n2) {
                portBlockPart = this.getConnection(n2);
                dArray2 = portBlockPart.getValues();
                for (int i = 0; i < this.mixer.length; ++i) {
                    int n3 = i;
                    this.mixer[n3] = this.mixer[n3] + dArray2[i];
                }
            }
            dArray = this.mixer;
        }
        this.current = dArray[0];
        return dArray;
    }

    private void printIndentation(PrintStream printStream, int n) {
        for (int i = 0; i < n; ++i) {
            printStream.print("    ");
        }
    }

    private String portToString(UnitBlockPort unitBlockPort) {
        UnitGenerator unitGenerator = unitBlockPort.getUnitGenerator();
        return unitGenerator.getClass().getSimpleName() + "." + unitBlockPort.getName();
    }

    public void printConnections(PrintStream printStream, int n) {
        for (int i = 0; i < this.getConnectionCount(); ++i) {
            PortBlockPart portBlockPart = this.getConnection(i);
            this.printIndentation(printStream, n);
            printStream.println(this.portToString(this.getPort()) + " <--- " + this.portToString(portBlockPart.getPort()));
            portBlockPart.getPort().getUnitGenerator().printConnections(printStream, n + 1);
        }
    }
}

