/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.io;

import com.jsyn.io.AudioInputStream;
import com.jsyn.io.AudioOutputStream;

public class AudioFifo
implements AudioInputStream,
AudioOutputStream {
    private volatile int readIndex;
    private volatile int writeIndex;
    private volatile double[] buffer;
    private int accessMask;
    private int sizeMask;
    private boolean writeWaitEnabled = true;
    private boolean readWaitEnabled = true;
    private Object writeSemaphore = new Object();
    private Object readSemaphore = new Object();

    public void allocate(int n) {
        if (!AudioFifo.isPowerOfTwo(n)) {
            throw new IllegalArgumentException("Size must be a power of two.");
        }
        this.buffer = new double[n];
        this.accessMask = n - 1;
        this.sizeMask = n * 2 - 1;
    }

    public int size() {
        return this.buffer.length;
    }

    public static boolean isPowerOfTwo(int n) {
        return (n & n - 1) == 0;
    }

    public int available() {
        return this.writeIndex - this.readIndex & this.sizeMask;
    }

    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double read() {
        double d = Double.NaN;
        if (this.readWaitEnabled) {
            try {
                while (this.available() < 1) {
                    Object object = this.writeSemaphore;
                    synchronized (object) {
                        this.writeSemaphore.wait();
                    }
                }
                d = this.readOneInternal();
            }
            catch (InterruptedException interruptedException) {}
        } else if (this.readIndex != this.writeIndex) {
            d = this.readOneInternal();
        }
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double readOneInternal() {
        double d = this.buffer[this.readIndex & this.accessMask];
        this.readIndex = this.readIndex + 1 & this.sizeMask;
        if (this.writeWaitEnabled) {
            Object object = this.readSemaphore;
            synchronized (object) {
                this.readSemaphore.notify();
            }
        }
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(double d) {
        if (this.writeWaitEnabled) {
            try {
                while (this.available() == this.buffer.length) {
                    Object object = this.readSemaphore;
                    synchronized (object) {
                        this.readSemaphore.wait();
                    }
                }
                this.writeOneInternal(d);
            }
            catch (InterruptedException interruptedException) {}
        } else if (this.available() != this.buffer.length) {
            this.writeOneInternal(d);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeOneInternal(double d) {
        this.buffer[this.writeIndex & this.accessMask] = d;
        this.writeIndex = this.writeIndex + 1 & this.sizeMask;
        if (this.readWaitEnabled) {
            Object object = this.writeSemaphore;
            synchronized (object) {
                this.writeSemaphore.notify();
            }
        }
    }

    public int read(double[] dArray) {
        return this.read(dArray, 0, dArray.length);
    }

    public int read(double[] dArray, int n, int n2) {
        if (this.readWaitEnabled) {
            for (int i = 0; i < n2; ++i) {
                dArray[i + n] = this.read();
            }
        } else if (this.available() < n2) {
            n2 = this.available();
        } else {
            for (int i = 0; i < n2; ++i) {
                dArray[i + n] = this.read();
            }
        }
        return n2;
    }

    public void write(double[] dArray) {
        this.write(dArray, 0, dArray.length);
    }

    public void write(double[] dArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            this.write(dArray[i + n]);
        }
    }

    public void setWriteWaitEnabled(boolean bl) {
        this.writeWaitEnabled = bl;
    }

    public void setReadWaitEnabled(boolean bl) {
        this.readWaitEnabled = bl;
    }

    public boolean isWriteWaitEnabled() {
        return this.writeWaitEnabled;
    }

    public boolean isReadWaitEnabled() {
        return this.readWaitEnabled;
    }
}

