/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.instruments;

import com.jsyn.data.DoubleTable;
import com.jsyn.ports.UnitFunctionPort;
import com.jsyn.ports.UnitInputPort;
import com.jsyn.ports.UnitOutputPort;
import com.jsyn.unitgen.Circuit;
import com.jsyn.unitgen.EnvelopeDAHDSR;
import com.jsyn.unitgen.FunctionEvaluator;
import com.jsyn.unitgen.Multiply;
import com.jsyn.unitgen.SineOscillator;
import com.jsyn.unitgen.UnitOscillator;
import com.jsyn.unitgen.UnitVoice;
import com.jsyn.util.VoiceDescription;
import com.softsynth.math.ChebyshevPolynomial;
import com.softsynth.math.PolynomialTableData;
import com.softsynth.shared.time.TimeStamp;

public class WaveShapingVoice
extends Circuit
implements UnitVoice {
    private static final long serialVersionUID = -2704222221111608377L;
    private static final int NUM_PRESETS = 3;
    private UnitOscillator osc;
    private FunctionEvaluator waveShaper;
    private EnvelopeDAHDSR ampEnv;
    private EnvelopeDAHDSR rangeEnv;
    private Multiply frequencyScaler = new Multiply();
    public UnitInputPort range;
    public UnitInputPort frequency;
    public UnitInputPort amplitude;
    public UnitFunctionPort function;
    public UnitInputPort pitchModulation;
    private static DoubleTable chebyshevTable;
    private static final int CHEBYSHEV_ORDER = 11;

    public WaveShapingVoice() {
        this.add(this.frequencyScaler);
        this.osc = new SineOscillator();
        this.add(this.osc);
        this.waveShaper = new FunctionEvaluator();
        this.add(this.waveShaper);
        this.rangeEnv = new EnvelopeDAHDSR();
        this.add(this.rangeEnv);
        this.ampEnv = new EnvelopeDAHDSR();
        this.add(this.ampEnv);
        this.amplitude = this.ampEnv.amplitude;
        this.addPort(this.amplitude);
        this.range = this.osc.amplitude;
        this.addPort(this.range, "Range");
        this.function = this.waveShaper.function;
        this.addPort(this.function);
        this.frequency = this.frequencyScaler.inputA;
        this.addPort(this.frequency, "Frequency");
        this.pitchModulation = this.frequencyScaler.inputB;
        this.addPort(this.pitchModulation, "PitchMod");
        this.ampEnv.export(this, "Amp");
        this.rangeEnv.export(this, "Range");
        this.function.set(chebyshevTable);
        this.osc.output.connect(this.rangeEnv.amplitude);
        this.rangeEnv.output.connect(this.waveShaper.input);
        this.ampEnv.output.connect(this.waveShaper.amplitude);
        this.frequencyScaler.output.connect(this.osc.frequency);
        this.pitchModulation.setup(0.1, 1.0, 10.0);
        this.range.setup(0.1, 0.8, 1.0);
        this.frequency.setup(this.osc.frequency);
        this.amplitude.setup(0.0, 0.5, 1.0);
        this.ampEnv.setupAutoDisable(this);
        this.usePreset(2);
    }

    public UnitOutputPort getOutput() {
        return this.waveShaper.output;
    }

    public void noteOn(double d, double d2, TimeStamp timeStamp) {
        this.frequency.set(d, timeStamp);
        this.amplitude.set(d2, timeStamp);
        this.ampEnv.input.on(timeStamp);
        this.rangeEnv.input.on(timeStamp);
    }

    public void noteOff(TimeStamp timeStamp) {
        this.ampEnv.input.off(timeStamp);
        this.rangeEnv.input.off(timeStamp);
    }

    public void usePreset(int n) {
        int n2 = n % 3;
        switch (n2) {
            case 0: {
                this.ampEnv.attack.set(0.01);
                this.ampEnv.decay.set(0.2);
                this.ampEnv.release.set(1.0);
                this.rangeEnv.attack.set(0.01);
                this.rangeEnv.decay.set(0.2);
                this.rangeEnv.sustain.set(0.4);
                this.rangeEnv.release.set(1.0);
                break;
            }
            case 1: {
                this.ampEnv.attack.set(0.5);
                this.ampEnv.decay.set(0.3);
                this.ampEnv.release.set(0.2);
                this.rangeEnv.attack.set(0.03);
                this.rangeEnv.decay.set(0.2);
                this.rangeEnv.sustain.set(0.5);
                this.rangeEnv.release.set(1.0);
                break;
            }
            default: {
                this.ampEnv.attack.set(0.1);
                this.ampEnv.decay.set(0.3);
                this.ampEnv.release.set(0.5);
                this.rangeEnv.attack.set(0.01);
                this.rangeEnv.decay.set(0.2);
                this.rangeEnv.sustain.set(0.9);
                this.rangeEnv.release.set(1.0);
            }
        }
    }

    public static VoiceDescription getVoiceDescription() {
        return new MyVoiceDescription();
    }

    static {
        PolynomialTableData polynomialTableData = new PolynomialTableData(ChebyshevPolynomial.T(11), 1024);
        chebyshevTable = new DoubleTable(polynomialTableData.getData());
    }

    static class MyVoiceDescription
    extends VoiceDescription {
        static String[] presetNames = new String[]{"FastChebyshev", "SlowChebyshev", "BrightChebyshev"};
        static String[] tags = new String[]{"electronic", "waveshaping", "clean"};

        public MyVoiceDescription() {
            super("Waveshaping", presetNames);
        }

        public UnitVoice createUnitVoice() {
            return new WaveShapingVoice();
        }

        public String[] getTags(int n) {
            return tags;
        }

        public String getVoiceClassName() {
            return WaveShapingVoice.class.getName();
        }
    }
}

