/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.instruments;

import com.jsyn.ports.UnitInputPort;
import com.jsyn.ports.UnitOutputPort;
import com.jsyn.unitgen.Add;
import com.jsyn.unitgen.Circuit;
import com.jsyn.unitgen.EnvelopeAttackDecay;
import com.jsyn.unitgen.Multiply;
import com.jsyn.unitgen.PassThrough;
import com.jsyn.unitgen.SineOscillator;
import com.jsyn.unitgen.SineOscillatorPhaseModulated;
import com.jsyn.unitgen.UnitVoice;
import com.jsyn.util.VoiceDescription;
import com.softsynth.shared.time.TimeStamp;

public class DrumWoodFM
extends Circuit
implements UnitVoice {
    private static final int NUM_PRESETS = 3;
    EnvelopeAttackDecay ampEnv;
    SineOscillatorPhaseModulated carrierOsc = new SineOscillatorPhaseModulated();
    EnvelopeAttackDecay modEnv;
    SineOscillator modOsc;
    PassThrough freqDistributor;
    Add modSummer;
    Multiply frequencyMultiplier;
    public UnitInputPort mcratio;
    public UnitInputPort index;
    public UnitInputPort modRange;
    public UnitInputPort frequency;

    public DrumWoodFM() {
        this.add(this.carrierOsc);
        this.freqDistributor = new PassThrough();
        this.add(this.freqDistributor);
        this.modSummer = new Add();
        this.add(this.modSummer);
        this.ampEnv = new EnvelopeAttackDecay();
        this.add(this.ampEnv);
        this.modEnv = new EnvelopeAttackDecay();
        this.add(this.modEnv);
        this.modOsc = new SineOscillator();
        this.add(this.modOsc);
        this.frequencyMultiplier = new Multiply();
        this.add(this.frequencyMultiplier);
        this.mcratio = this.frequencyMultiplier.inputB;
        this.addPort(this.mcratio, "MCRatio");
        this.index = this.modSummer.inputA;
        this.addPort(this.index, "Index");
        this.modRange = this.modEnv.amplitude;
        this.addPort(this.modRange, "ModRange");
        this.frequency = this.freqDistributor.input;
        this.addPort(this.frequency, "Frequency");
        this.ampEnv.export(this, "Amp");
        this.modEnv.export(this, "Mod");
        this.freqDistributor.output.connect(this.carrierOsc.frequency);
        this.freqDistributor.output.connect(this.frequencyMultiplier.inputA);
        this.carrierOsc.output.connect(this.ampEnv.amplitude);
        this.modEnv.output.connect(this.modSummer.inputB);
        this.modSummer.output.connect(this.modOsc.amplitude);
        this.modOsc.output.connect(this.carrierOsc.modulation);
        this.frequencyMultiplier.output.connect(this.modOsc.frequency);
        this.ampEnv.setupAutoDisable(this);
        this.usePreset(0);
    }

    public void noteOff(TimeStamp timeStamp) {
    }

    public void noteOn(double d, double d2, TimeStamp timeStamp) {
        this.carrierOsc.amplitude.set(d2, timeStamp);
        this.ampEnv.input.trigger(timeStamp);
        this.modEnv.input.trigger(timeStamp);
    }

    public UnitOutputPort getOutput() {
        return this.ampEnv.output;
    }

    public void usePreset(int n) {
        this.mcratio.setup(0.001, 0.6875, 20.0);
        this.ampEnv.attack.setup(0.001, 0.005, 8.0);
        this.modEnv.attack.setup(0.001, 0.005, 8.0);
        int n2 = n % 3;
        switch (n2) {
            case 0: {
                this.ampEnv.decay.setup(0.001, 0.293, 8.0);
                this.modEnv.decay.setup(0.001, 0.07, 8.0);
                this.frequency.setup(0.0, 349.0, 3000.0);
                this.index.setup(0.001, 0.05, 10.0);
                this.modRange.setup(0.001, 0.4, 10.0);
                break;
            }
            default: {
                this.ampEnv.decay.setup(0.001, 0.12, 8.0);
                this.modEnv.decay.setup(0.001, 0.06, 8.0);
                this.frequency.setup(0.0, 1400.0, 3000.0);
                this.index.setup(0.001, 0.16, 10.0);
                this.modRange.setup(0.001, 0.17, 10.0);
            }
        }
    }

    public static VoiceDescription getVoiceDescription() {
        return new MyVoiceDescription();
    }

    static class MyVoiceDescription
    extends VoiceDescription {
        static String[] presetNames = new String[]{"WoodBlockFM", "ClaveFM"};
        static String[] tags = new String[]{"electronic", "drum"};

        public MyVoiceDescription() {
            super("DrumWoodFM", presetNames);
        }

        public UnitVoice createUnitVoice() {
            return new DrumWoodFM();
        }

        public String[] getTags(int n) {
            return tags;
        }

        public String getVoiceClassName() {
            return DrumWoodFM.class.getName();
        }
    }
}

